"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _eui = require("@elastic/eui");
var _constants = require("../../../common/xsoar/constants");
var translations = _interopRequireWildcard(require("./translations"));
var _constants2 = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createOption = playbook => ({
  key: playbook.id,
  label: playbook.name
});
const renderPlaybook = ({
  label
}, searchValue, contentClassName) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  className: contentClassName,
  direction: "row",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
  search: searchValue
}, label)));
const XSOARParamsFields = ({
  actionConnector,
  actionParams,
  editAction,
  index,
  errors,
  messageVariables,
  executionMode
}) => {
  var _errors$playbook, _incident$severity;
  const {
    toasts
  } = (0, _public.useKibana)().notifications;
  const isTest = executionMode === _public.ActionConnectorMode.Test;
  const incident = (0, _react.useMemo)(() => {
    var _ref;
    return (_ref = actionParams.subActionParams) !== null && _ref !== void 0 ? _ref : {
      severity: _constants.XSOARSeverity.UNKNOWN,
      createInvestigation: false
    };
  }, [actionParams.subActionParams]);
  const [connectorId, setConnectorId] = (0, _react.useState)(actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.id);
  const [selectedPlaybookOption, setSelectedPlaybookOption] = (0, _react.useState)();
  const [isRuleSeverity, setIsRuleSeverity] = (0, _react.useState)(Boolean(incident.isRuleSeverity));
  const [playbooks, setPlaybooks] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    if (actionConnector != null && connectorId !== actionConnector.id) {
      setConnectorId(actionConnector === null || actionConnector === void 0 ? void 0 : actionConnector.id);
      setSelectedPlaybookOption(null);
      setIsRuleSeverity(isTest ? false : true);
      editAction('subActionParams', {
        severity: _constants.XSOARSeverity.UNKNOWN,
        createInvestigation: false
      }, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionConnector]);
  (0, _react.useEffect)(() => {
    if (!actionParams.subAction) {
      editAction('subAction', _constants.SUB_ACTION.RUN, index);
    }
    if (!actionParams.subActionParams) {
      editAction('subActionParams', incident, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionParams]);
  const {
    response: {
      playbooks: fetchedPlaybooks
    } = {},
    isLoading: isLoadingPlaybooks,
    error: playbooksError
  } = (0, _public.useSubAction)({
    connectorId,
    subAction: 'getPlaybooks'
  });
  (0, _react.useEffect)(() => {
    if (playbooksError) {
      toasts.danger({
        title: translations.PLAYBOOKS_ERROR,
        body: playbooksError.message
      });
      setPlaybooks([]);
    } else {
      setPlaybooks(fetchedPlaybooks);
    }
  }, [toasts, playbooksError, fetchedPlaybooks]);
  const playbooksOptions = (0, _react.useMemo)(() => {
    var _playbooks$map;
    return (_playbooks$map = playbooks === null || playbooks === void 0 ? void 0 : playbooks.map(createOption)) !== null && _playbooks$map !== void 0 ? _playbooks$map : [];
  }, [playbooks]);
  (0, _react.useEffect)(() => {
    if (selectedPlaybookOption === undefined && incident.playbookId && playbooks !== undefined) {
      const selectedPlaybook = playbooks.find(({
        id
      }) => id === incident.playbookId);
      if (selectedPlaybook) {
        setSelectedPlaybookOption(createOption(selectedPlaybook));
      } else {
        toasts.warning({
          title: translations.PLAYBOOK_NOT_FOUND_WARNING
        });
        editAction('subActionParams', {
          ...incident,
          playbookId: undefined,
          createInvestigation: false
        }, index);
      }
    }
    if (selectedPlaybookOption !== undefined && (selectedPlaybookOption === null || selectedPlaybookOption === void 0 ? void 0 : selectedPlaybookOption.key) !== incident.playbookId) {
      editAction('subActionParams', {
        ...incident,
        playbookId: selectedPlaybookOption === null || selectedPlaybookOption === void 0 ? void 0 : selectedPlaybookOption.key,
        createInvestigation: selectedPlaybookOption === null ? false : incident.createInvestigation
      }, index);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedPlaybookOption, incident.playbookId, playbooks, toasts, editAction, index]);
  const selectedPlaybookOptions = (0, _react.useMemo)(() => selectedPlaybookOption ? [selectedPlaybookOption] : [], [selectedPlaybookOption]);
  const onChangePlaybook = (0, _react.useCallback)(([selected]) => {
    setSelectedPlaybookOption(selected !== null && selected !== void 0 ? selected : null);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: (key, value) => {
      editAction('subActionParams', {
        ...incident,
        [key]: value
      }, index);
    },
    messageVariables: messageVariables,
    paramsProperty: 'name',
    inputTargetValue: incident.name,
    wrapField: true,
    formRowProps: {
      label: translations.NAME_LABEL,
      fullWidth: true,
      helpText: '',
      isInvalid: errors.name !== undefined && Number(errors.name.length) > 0 && incident.name !== undefined,
      error: errors.name
    },
    errors: errors.name
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.playbook,
    isInvalid: !!((_errors$playbook = errors.playbook) !== null && _errors$playbook !== void 0 && _errors$playbook.length) && selectedPlaybookOption !== undefined,
    label: translations.PLAYBOOK_LABEL,
    helpText: translations.PLAYBOOK_HELP
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": translations.PLAYBOOK_ARIA_LABEL,
    placeholder: translations.PLAYBOOK_PLACEHOLDER,
    singleSelection: {
      asPlainText: true
    },
    options: playbooksOptions,
    selectedOptions: selectedPlaybookOptions,
    onChange: onChangePlaybook,
    isDisabled: isLoadingPlaybooks,
    isLoading: isLoadingPlaybooks,
    renderOption: renderPlaybook,
    fullWidth: true,
    "data-test-subj": "xsoar-playbookSelector"
  })), selectedPlaybookOption && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: translations.START_INVESTIGATION_LABEL,
    checked: incident.createInvestigation,
    "data-test-subj": "createInvestigation-toggle",
    onChange: e => {
      editAction('subActionParams', {
        ...incident,
        createInvestigation: e.target.checked
      }, index);
    }
  })), !isTest && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: translations.IS_RULE_SEVERITY_LABEL,
    checked: Boolean(isRuleSeverity),
    "data-test-subj": "rule-severity-toggle",
    onChange: e => {
      setIsRuleSeverity(e.target.checked);
      editAction('subActionParams', {
        ...incident,
        isRuleSeverity: e.target.checked
      }, index);
    }
  })), !Boolean(isRuleSeverity) && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: translations.SEVERITY_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "severitySelectInput",
    disabled: Boolean(isRuleSeverity),
    value: (_incident$severity = incident.severity) !== null && _incident$severity !== void 0 ? _incident$severity : _constants2.severityOptions[0].value,
    options: _constants2.severityOptions,
    onChange: e => {
      editAction('subActionParams', {
        ...incident,
        severity: parseFloat(e.target.value)
      }, index);
    }
  })), /*#__PURE__*/_react.default.createElement(_public.JsonEditorWithMessageVariables, {
    key: connectorId,
    messageVariables: messageVariables,
    paramsProperty: 'body',
    inputTargetValue: incident.body,
    label: translations.BODY_LABEL,
    ariaLabel: translations.BODY_DESCRIPTION,
    onDocumentsChange: json => editAction('subActionParams', {
      ...incident,
      body: json
    }, index),
    dataTestSubj: "xsoar-body",
    onBlur: () => {
      if (!incident.body) {
        editAction('subActionParams', {
          ...incident,
          body: null
        }, index);
      }
    }
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = XSOARParamsFields;
module.exports = exports.default;