"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CopyToSpaceForm = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _copy_mode_control = require("./copy_mode_control");
var _selectable_spaces_control = require("./selectable_spaces_control");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CopyToSpaceForm = props => {
  const {
    savedObjectTarget,
    spaces,
    onUpdate,
    copyOptions
  } = props;

  // if the user is not creating new copies, prevent them from copying objects an object into a space where it already exists
  const getDisabledSpaceIds = createNewCopies => createNewCopies ? new Set() : savedObjectTarget.namespaces.reduce((acc, cur) => acc.add(cur), new Set());
  const changeCopyMode = ({
    createNewCopies,
    overwrite
  }) => {
    const disabled = getDisabledSpaceIds(createNewCopies);
    const selectedSpaceIds = copyOptions.selectedSpaceIds.filter(x => !disabled.has(x));
    onUpdate({
      ...copyOptions,
      createNewCopies,
      overwrite,
      selectedSpaceIds
    });
  };
  const setSelectedSpaceIds = selectedSpaceIds => onUpdate({
    ...copyOptions,
    selectedSpaceIds
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "copy-to-space-form"
  }, /*#__PURE__*/_react.default.createElement(_copy_mode_control.CopyModeControl, {
    initialValues: copyOptions,
    updateSelection: newValues => changeCopyMode(newValues)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.selectSpacesLabel",
      defaultMessage: "Select spaces"
    }))),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_selectable_spaces_control.SelectableSpacesControl, {
    spaces: spaces,
    selectedSpaceIds: copyOptions.selectedSpaceIds,
    disabledSpaceIds: getDisabledSpaceIds(copyOptions.createNewCopies),
    onChange: selection => setSelectedSpaceIds(selection)
  })));
};
exports.CopyToSpaceForm = CopyToSpaceForm;