"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RepositoryVerificationBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RepositoryVerificationBadge = ({
  verificationResults
}) => {
  if (!verificationResults) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryVerification.verificationUnknownValue",
      defaultMessage: "Unknown"
    }));
  }
  if (verificationResults.valid) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "success"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.repositoryVerification.verificationSuccessfulValue",
      defaultMessage: "Connected"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.repositoryVerification.verificationErrorValue",
    defaultMessage: "Not connected"
  }));
};
exports.RepositoryVerificationBadge = RepositoryVerificationBadge;