"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteSLOInstances = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _constants = require("../../common/constants");
var _errors = require("../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DeleteSLOInstances {
  constructor(esClient) {
    this.esClient = esClient;
  }
  async execute(params) {
    const containsAllValueInstanceId = params.list.some(item => item.instanceId === _sloSchema.ALL_VALUE);
    if (containsAllValueInstanceId) {
      throw new _errors.IllegalArgumentError("Cannot delete an SLO instance '*'");
    }
    await Promise.all([this.deleteRollupData(params.list), this.deleteSummaryData(params.list)]);
  }

  // Delete rollup data when excluding rollup data is not explicitly requested
  async deleteRollupData(list) {
    await this.esClient.deleteByQuery({
      index: _constants.SLI_DESTINATION_INDEX_PATTERN,
      wait_for_completion: false,
      conflicts: 'proceed',
      slices: 'auto',
      query: {
        bool: {
          should: list.filter(item => item.excludeRollup !== true).map(item => ({
            bool: {
              must: [{
                term: {
                  'slo.id': item.sloId
                }
              }, {
                term: {
                  'slo.instanceId': item.instanceId
                }
              }]
            }
          }))
        }
      }
    });
  }
  async deleteSummaryData(list) {
    await this.esClient.deleteByQuery({
      index: _constants.SUMMARY_DESTINATION_INDEX_PATTERN,
      refresh: true,
      wait_for_completion: false,
      conflicts: 'proceed',
      slices: 'auto',
      query: {
        bool: {
          should: list.map(item => ({
            bool: {
              must: [{
                term: {
                  'slo.id': item.sloId
                }
              }, {
                term: {
                  'slo.instanceId': item.instanceId
                }
              }]
            }
          }))
        }
      }
    });
  }
}
exports.DeleteSLOInstances = DeleteSLOInstances;