"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkOperationProvider = BulkOperationProvider;
exports.useBulkOperation = void 0;
var _reactQuery = require("@tanstack/react-query");
var _react = _interopRequireWildcard(require("react"));
var _query_key_factory = require("../../../hooks/query_key_factory");
var _use_plugin_context = require("../../../hooks/use_plugin_context");
var _use_kibana = require("../../../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBulkOperation = () => {
  const context = (0, _react.useContext)(BulkOperationContext);
  if (!context) {
    throw new Error('useBulkOperation must be used within a BulkOperationProvider');
  }
  return context;
};
exports.useBulkOperation = useBulkOperation;
const BulkOperationContext = /*#__PURE__*/(0, _react.createContext)(undefined);
function BulkOperationProvider({
  children
}) {
  const {
    notifications: {
      toasts
    }
  } = (0, _use_kibana.useKibana)().services;
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    sloClient
  } = (0, _use_plugin_context.usePluginContext)();
  const [tasks, setTasks] = (0, _react.useState)([]);
  const register = (0, _react.useCallback)(task => {
    setTasks(prevTasks => [...prevTasks, {
      ...task,
      items: task.items.map(item => ({
        ...item,
        success: false
      })),
      status: 'in-progress',
      createdAt: new Date(),
      updatedAt: new Date()
    }]);
  }, []);
  (0, _reactQuery.useQueries)({
    queries: tasks.filter(task => task.status === 'in-progress').map(task => ({
      queryKey: _query_key_factory.sloKeys.bulkDeleteStatus(task.taskId),
      queryFn: async () => {
        var _response$results2, _response$results3;
        const response = await sloClient.fetch('GET /api/observability/slos/_bulk_delete/{taskId} 2023-10-31', {
          params: {
            path: {
              taskId: task.taskId
            }
          }
        });
        if (!response.isDone) {
          setTasks(prevTasks => prevTasks.map(prevTask => {
            if (prevTask.taskId === task.taskId) {
              return {
                ...prevTask,
                status: 'in-progress',
                updatedAt: new Date()
              };
            }
            return prevTask;
          }));
          return response;
        }
        queryClient.invalidateQueries({
          queryKey: _query_key_factory.sloKeys.allDefinitions(),
          exact: false
        });
        if (!!response.error) {
          setTasks(prevTasks => prevTasks.map(prevTask => {
            if (prevTask.taskId === task.taskId) {
              return {
                ...prevTask,
                items: prevTask.items.map(item => ({
                  ...item,
                  success: false,
                  error: response.error
                })),
                status: 'failed',
                error: response.error,
                updatedAt: new Date()
              };
            }
            return prevTask;
          }));
          toasts.addError(new Error(response.error), {
            title: `Bulk ${task.operation} failed`
          });
          return response;
        }
        setTasks(prevTasks => prevTasks.map(prevTask => {
          if (prevTask.taskId === task.taskId) {
            return {
              ...prevTask,
              items: prevTask.items.map(item => {
                var _response$results, _result$success;
                const result = (_response$results = response.results) === null || _response$results === void 0 ? void 0 : _response$results.find(i => i.id === item.id);
                return {
                  ...item,
                  success: (_result$success = result === null || result === void 0 ? void 0 : result.success) !== null && _result$success !== void 0 ? _result$success : false,
                  error: result === null || result === void 0 ? void 0 : result.error
                };
              }),
              status: 'completed',
              updatedAt: new Date()
            };
          }
          return prevTask;
        }));
        toasts.addSuccess({
          title: `Bulk ${task.operation} completed`,
          text: `Successfully deleted ${(_response$results2 = response.results) === null || _response$results2 === void 0 ? void 0 : _response$results2.filter(i => i.success).length} on ${(_response$results3 = response.results) === null || _response$results3 === void 0 ? void 0 : _response$results3.length} SLOs`
        });
        return response;
      },
      refetchInterval: 3000,
      retry: false,
      refetchOnWindowFocus: false
    }))
  });
  return /*#__PURE__*/_react.default.createElement(BulkOperationContext.Provider, {
    value: {
      register,
      tasks
    }
  }, children);
}