"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloManagementTable = SloManagementTable;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _react = _interopRequireWildcard(require("react"));
var _common = require("../../../../common");
var _constants = require("../../../../common/constants");
var _paths = require("../../../../common/locators/paths");
var _use_fetch_slo_definitions = require("../../../hooks/use_fetch_slo_definitions");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_permissions = require("../../../hooks/use_permissions");
var _action_modal = require("../../../context/action_modal");
var _bulk_operation = require("../context/bulk_operation");
var _use_url_search_state = require("../hooks/use_url_search_state");
var _slo_management_bulk_actions = require("./slo_management_bulk_actions");
var _slo_management_search_bar = require("./slo_management_search_bar");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloManagementTable() {
  var _data$total, _data$results$length, _data$total2, _data$results;
  const {
    state,
    onStateChange
  } = (0, _use_url_search_state.useUrlSearchState)();
  const {
    search,
    page,
    perPage,
    tags,
    includeOutdatedOnly
  } = state;
  const {
    services: {
      http,
      application: {
        navigateToUrl
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    triggerAction
  } = (0, _action_modal.useActionModal)();
  const {
    data: permissions
  } = (0, _use_permissions.usePermissions)();
  const {
    isLoading,
    isError,
    data,
    refetch
  } = (0, _use_fetch_slo_definitions.useFetchSloDefinitions)({
    page: page + 1,
    perPage,
    name: search,
    tags,
    includeOutdatedOnly
  });
  const {
    tasks
  } = (0, _bulk_operation.useBulkOperation)();
  const [selectedItems, setSelectedItems] = (0, _react.useState)([]);
  const onSelectionChange = items => {
    setSelectedItems(items);
  };
  const selection = {
    selected: selectedItems,
    selectable: item => {
      return !tasks.find(task => task.status === 'in-progress' && task.items.some(i => i.id === item.id));
    },
    onSelectionChange
  };
  const actions = [{
    type: 'icon',
    icon: 'pencil',
    name: _i18n.i18n.translate('xpack.slo.item.actions.edit', {
      defaultMessage: 'Edit'
    }),
    description: _i18n.i18n.translate('xpack.slo.item.actions.edit', {
      defaultMessage: 'Edit'
    }),
    'data-test-subj': 'sloActionsEdit',
    enabled: () => !!(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested),
    onClick: slo => {
      navigateToUrl(http.basePath.prepend(_paths.paths.sloEdit(slo.id)));
    }
  }, {
    type: 'icon',
    icon: 'copy',
    name: _i18n.i18n.translate('xpack.slo.item.actions.clone', {
      defaultMessage: 'Clone'
    }),
    description: _i18n.i18n.translate('xpack.slo.item.actions.clone', {
      defaultMessage: 'Clone'
    }),
    enabled: () => !!(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested),
    'data-test-subj': 'sloActionsClone',
    onClick: slo => triggerAction({
      item: slo,
      type: 'clone'
    })
  }, {
    type: 'icon',
    icon: slo => slo.enabled ? 'stop' : 'play',
    name: slo => slo.enabled ? _i18n.i18n.translate('xpack.slo.item.actions.disable', {
      defaultMessage: 'Disable'
    }) : _i18n.i18n.translate('xpack.slo.item.actions.enable', {
      defaultMessage: 'Enable'
    }),
    description: slo => slo.enabled ? _i18n.i18n.translate('xpack.slo.item.actions.disable', {
      defaultMessage: 'Disable'
    }) : _i18n.i18n.translate('xpack.slo.item.actions.enable', {
      defaultMessage: 'Enable'
    }),
    'data-test-subj': 'sloActionsManage',
    enabled: () => !!(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested),
    onClick: slo => {
      const isEnabled = slo.enabled;
      triggerAction({
        item: slo,
        type: isEnabled ? 'disable' : 'enable'
      });
    }
  }, {
    type: 'icon',
    icon: 'trash',
    name: _i18n.i18n.translate('xpack.slo.item.actions.delete', {
      defaultMessage: 'Delete'
    }),
    description: _i18n.i18n.translate('xpack.slo.item.actions.delete', {
      defaultMessage: 'Delete'
    }),
    'data-test-subj': 'sloActionsDelete',
    enabled: () => !!(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested),
    onClick: slo => triggerAction({
      item: slo,
      type: 'delete'
    })
  }, {
    type: 'icon',
    icon: 'logstashOutput',
    name: _i18n.i18n.translate('xpack.slo.item.actions.purge', {
      defaultMessage: 'Purge'
    }),
    description: _i18n.i18n.translate('xpack.slo.item.actions.purge', {
      defaultMessage: 'Purge'
    }),
    'data-test-subj': 'sloActionsPurge',
    enabled: () => !!(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested),
    onClick: slo => triggerAction({
      item: slo,
      type: 'purge'
    })
  }, {
    type: 'icon',
    icon: 'refresh',
    name: _i18n.i18n.translate('xpack.slo.item.actions.reset', {
      defaultMessage: 'Reset'
    }),
    description: _i18n.i18n.translate('xpack.slo.item.actions.reset', {
      defaultMessage: 'Reset'
    }),
    'data-test-subj': 'sloActionsReset',
    enabled: () => !!(permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested),
    onClick: slo => triggerAction({
      item: slo,
      type: 'reset'
    })
  }];
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.slo.sloManagementTable.columns.nameLabel', {
      defaultMessage: 'Name'
    }),
    render: (_, slo) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "sloDetailsLink",
        href: http.basePath.prepend(_common.sloPaths.sloDetails(slo.id, _sloSchema.ALL_VALUE)),
        target: "_blank"
      }, slo.name);
    }
  }, {
    field: 'version',
    width: '10%',
    name: _i18n.i18n.translate('xpack.slo.sloManagementTable.columns.versionLabel', {
      defaultMessage: 'Version'
    }),
    render: value => {
      return value < _constants.SLO_MODEL_VERSION ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, _i18n.i18n.translate('xpack.slo.sloManagementTable.version.outdated', {
        defaultMessage: 'Outdated'
      })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, _i18n.i18n.translate('xpack.slo.sloManagementTable.version.current', {
        defaultMessage: 'Current'
      }));
    }
  }, {
    field: 'tags',
    name: _i18n.i18n.translate('xpack.slo.sloManagementTable.columns.tagsLabel', {
      defaultMessage: 'Tags'
    }),
    render: value => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        wrap: true,
        responsive: true
      }, value.map(tag => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: tag,
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, tag))));
    }
  }, {
    field: 'State',
    width: '20%',
    name: _i18n.i18n.translate('xpack.slo.sloManagementTable.columns.state', {
      defaultMessage: 'State'
    }),
    render: (_, item) => {
      const color = item.enabled ? 'success' : 'danger';
      const label = item.enabled ? 'Running' : 'Paused';
      return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: color
      }, label);
    }
  }, {
    name: 'Actions',
    width: '10%',
    actions
  }];
  const onTableChange = ({
    page: newPage
  }) => {
    if (newPage) {
      const {
        index,
        size
      } = newPage;
      const newState = {
        ...state,
        page: index,
        perPage: size
      };
      onStateChange(newState);
    }
  };
  const pagination = {
    pageIndex: page,
    pageSize: perPage,
    totalItemCount: (_data$total = data === null || data === void 0 ? void 0 : data.total) !== null && _data$total !== void 0 ? _data$total : 0,
    pageSizeOptions: [10, 25, 50, 100],
    showPerPageOptions: true
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_slo_management_search_bar.SloManagementSearchBar, {
    onRefresh: refetch
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), !selectedItems.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, _i18n.i18n.translate('xpack.slo.sloManagementTable.itemCount', {
    defaultMessage: 'Showing {count} of {total} SLOs',
    values: {
      count: (_data$results$length = data === null || data === void 0 ? void 0 : data.results.length) !== null && _data$results$length !== void 0 ? _data$results$length : 0,
      total: (_data$total2 = data === null || data === void 0 ? void 0 : data.total) !== null && _data$total2 !== void 0 ? _data$total2 : 0
    }
  })) : /*#__PURE__*/_react.default.createElement(_slo_management_bulk_actions.SloManagementBulkActions, {
    items: selectedItems,
    setSelectedItems: onSelectionChange
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableCaption: TABLE_CAPTION,
    error: isError ? _i18n.i18n.translate('xpack.slo.sloManagementTable.error', {
      defaultMessage: 'An error occurred while retrieving SLO definitions'
    }) : undefined,
    items: (_data$results = data === null || data === void 0 ? void 0 : data.results) !== null && _data$results !== void 0 ? _data$results : [],
    rowHeader: "name",
    columns: columns,
    itemId: "id",
    pagination: pagination,
    onChange: onTableChange,
    loading: isLoading,
    selection: permissions !== null && permissions !== void 0 && permissions.hasAllWriteRequested ? selection : undefined
  }));
}
const TABLE_CAPTION = _i18n.i18n.translate('xpack.slo.sloManagement.tableCaption', {
  defaultMessage: 'SLO Management'
});