"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThrowIfError = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * This component allows errors to be caught outside of a render tree, and re-thrown within a render tree
 * wrapped by KibanaErrorBoundary. The purpose is to let KibanaErrorBoundary control the user experience when
 * React can not render due to an error.
 *
 * @public
 */
const ThrowIfError = ({
  error
}) => {
  if (error) {
    throw error;
  }
  return null;
};
exports.ThrowIfError = ThrowIfError;