"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getListsOverview = void 0;
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getListsOverview = async ({
  logger,
  esClient
}) => {
  try {
    const query = {
      expand_wildcards: ['open', 'hidden'],
      index: '.lists*',
      ignore_unavailable: false,
      size: 0,
      // no query results required - only aggregation quantity
      aggs: {
        by_type: {
          terms: {
            field: 'type'
          }
        }
      }
    };
    logger.debug(`Fetching value lists overview metrics: ${JSON.stringify(query, null, 2)}`);
    const response = await esClient.search(query);
    const {
      aggregations: aggs,
      hits
    } = response;
    const listTypes = aggs.by_type.buckets.reduce((aggResult, typeBucket) => {
      var _aggResult$listType;
      const listType = typeBucket.key;
      const count = typeBucket.doc_count;
      const updatedResult = {
        ...aggResult,
        [listType]: ((_aggResult$listType = aggResult[listType]) !== null && _aggResult$listType !== void 0 ? _aggResult$listType : 0) + count
      };
      return updatedResult;
    }, _utils.METRICS_LISTS_DEFAULT_STATE);
    logger.debug(`Returning value lists overview metrics response: ${JSON.stringify(listTypes, null, 2)}`);
    return {
      ...listTypes,
      total: hits.total.value
    };
  } catch (error) {
    logger.error(`Error fetching value lists overview metrics: ${error.message}`);
    // Return default state if an error occurs
    return {
      ..._utils.METRICS_LISTS_DEFAULT_STATE,
      total: 0
    };
  }
};
exports.getListsOverview = getListsOverview;