"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDetectionsMetrics = void 0;
var _get_metrics = require("./ml_jobs/get_metrics");
var _get_metrics2 = require("./rules/get_metrics");
var _get_initial_usage = require("./rules/get_initial_usage");
var _get_initial_usage2 = require("./ml_jobs/get_initial_usage");
var _get_initial_usage3 = require("./legacy_siem_signals/get_initial_usage");
var _get_legacy_siem_signals_metrics = require("./legacy_siem_signals/get_legacy_siem_signals_metrics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line no-restricted-imports

// eslint-disable-next-line no-restricted-imports

const getDetectionsMetrics = async ({
  eventLogIndex,
  signalsIndex,
  esClient,
  savedObjectsClient,
  logger,
  mlClient,
  legacySignalsIndex
}) => {
  const [mlJobMetrics, detectionRuleMetrics, legacySiemSignalsUsage] = await Promise.allSettled([(0, _get_metrics.getMlJobMetrics)({
    mlClient,
    savedObjectsClient,
    logger
  }), (0, _get_metrics2.getRuleMetrics)({
    signalsIndex,
    eventLogIndex,
    esClient,
    savedObjectsClient,
    logger
  }), (0, _get_legacy_siem_signals_metrics.getLegacySiemSignalsUsage)({
    signalsIndex: legacySignalsIndex,
    esClient,
    logger
  })]);
  return {
    ml_jobs: mlJobMetrics.status === 'fulfilled' ? mlJobMetrics.value : {
      ml_job_metrics: [],
      ml_job_usage: (0, _get_initial_usage2.getInitialMlJobUsage)()
    },
    detection_rules: detectionRuleMetrics.status === 'fulfilled' ? detectionRuleMetrics.value : {
      detection_rule_detail: [],
      detection_rule_usage: (0, _get_initial_usage.getInitialRulesUsage)(),
      detection_rule_status: (0, _get_initial_usage.getInitialEventLogUsage)(),
      elastic_detection_rule_upgrade_status: (0, _get_initial_usage.getInitialRuleUpgradeStatus)(),
      spaces_usage: (0, _get_initial_usage.getInitialSpacesUsage)()
    },
    legacy_siem_signals: legacySiemSignalsUsage.status === 'fulfilled' ? legacySiemSignalsUsage.value : (0, _get_initial_usage3.getInitialLegacySiemSignalsUsage)()
  };
};
exports.getDetectionsMetrics = getDetectionsMetrics;