"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SentinelOneAgentStatusClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _stringify = require("../../../../utils/stringify");
var _constants = require("../../../../../../common/constants");
var _utils = require("../../../../utils");
var _ = require("../../..");
var _types = require("../../../../../../common/endpoint/types");
var _base_agent_status_client = require("../lib/base_agent_status_client");
var _errors = require("../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SENTINEL_ONE_AGENT_INDEX_PATTERN = `logs-sentinel_one.agent-*`;
var SENTINEL_ONE_NETWORK_STATUS = /*#__PURE__*/function (SENTINEL_ONE_NETWORK_STATUS) {
  SENTINEL_ONE_NETWORK_STATUS["CONNECTING"] = "connecting";
  SENTINEL_ONE_NETWORK_STATUS["CONNECTED"] = "connected";
  SENTINEL_ONE_NETWORK_STATUS["DISCONNECTING"] = "disconnecting";
  SENTINEL_ONE_NETWORK_STATUS["DISCONNECTED"] = "disconnected";
  return SENTINEL_ONE_NETWORK_STATUS;
}(SENTINEL_ONE_NETWORK_STATUS || {});
class SentinelOneAgentStatusClient extends _base_agent_status_client.AgentStatusClient {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "agentType", 'sentinel_one');
  }
  async getAgentStatuses(agentIds) {
    const esClient = this.options.esClient;
    const metadataService = this.options.endpointService.getEndpointMetadataService();
    const sortField = 'sentinel_one.agent.last_active_date';
    const searchRequest = {
      index: SENTINEL_ONE_AGENT_INDEX_PATTERN,
      from: 0,
      size: _constants.DEFAULT_MAX_TABLE_QUERY_SIZE,
      query: {
        bool: {
          should: [{
            bool: {
              filter: [{
                terms: {
                  'sentinel_one.agent.agent.id': agentIds
                }
              }]
            }
          }, {
            bool: {
              filter: [{
                terms: {
                  'sentinel_one.agent.uuid': agentIds
                }
              }]
            }
          }],
          minimum_should_match: 1
        }
      },
      collapse: {
        field: 'sentinel_one.agent.agent.id',
        inner_hits: {
          name: 'most_recent',
          size: 1,
          sort: [{
            [sortField]: {
              order: 'desc'
            }
          }],
          _source: ['sentinel_one.agent.agent.id', 'sentinel_one.agent.uuid', 'sentinel_one.agent.network_status', 'sentinel_one.agent.last_active_date', 'sentinel_one.agent.is_active', 'sentinel_one.agent.is_pending_uninstall', 'sentinel_one.agent.is_uninstalled']
        }
      },
      sort: [{
        [sortField]: {
          order: 'desc'
        }
      }],
      _source: false
    };
    try {
      var _searchResponse$hits, _searchResponse$hits$;
      const [searchResponse, allPendingActions] = await Promise.all([esClient.search(searchRequest, {
        ignore: [404]
      }), (0, _.getPendingActionsSummary)(esClient, metadataService, this.log, agentIds)]).catch(_utils.catchAndWrapError);
      this.log.debug(() => `Searching SentinelOne agent data index [${SENTINEL_ONE_AGENT_INDEX_PATTERN}] with:\n${(0, _stringify.stringify)(searchRequest, 15)}\n\nReturned:\n${(0, _stringify.stringify)(searchResponse, 15)}`);
      const mostRecentAgentInfosByAgentId = searchResponse === null || searchResponse === void 0 ? void 0 : (_searchResponse$hits = searchResponse.hits) === null || _searchResponse$hits === void 0 ? void 0 : (_searchResponse$hits$ = _searchResponse$hits.hits) === null || _searchResponse$hits$ === void 0 ? void 0 : _searchResponse$hits$.reduce((acc, hit) => {
        var _hit$fields, _hit$fields$sentinel_;
        if ((_hit$fields = hit.fields) !== null && _hit$fields !== void 0 && (_hit$fields$sentinel_ = _hit$fields['sentinel_one.agent.agent.id']) !== null && _hit$fields$sentinel_ !== void 0 && _hit$fields$sentinel_[0]) {
          var _hit$inner_hits;
          acc[hit.fields['sentinel_one.agent.agent.id'][0]] = (_hit$inner_hits = hit.inner_hits) === null || _hit$inner_hits === void 0 ? void 0 : _hit$inner_hits.most_recent.hits.hits[0]._source;
        }
        return acc;
      }, {});
      const response = agentIds.reduce((acc, agentId) => {
        var _mostRecentAgentInfos, _mostRecentAgentInfos2, _pendingActions$pendi;
        const agentInfo = (_mostRecentAgentInfos = mostRecentAgentInfosByAgentId[agentId]) === null || _mostRecentAgentInfos === void 0 ? void 0 : (_mostRecentAgentInfos2 = _mostRecentAgentInfos.sentinel_one) === null || _mostRecentAgentInfos2 === void 0 ? void 0 : _mostRecentAgentInfos2.agent;
        const pendingActions = allPendingActions.find(agentPendingActions => agentPendingActions.agent_id === agentId);
        acc[agentId] = {
          agentId,
          agentType: this.agentType,
          found: (agentInfo === null || agentInfo === void 0 ? void 0 : agentInfo.uuid) === agentId || agentInfo.agent.id === agentId,
          isolated: (agentInfo === null || agentInfo === void 0 ? void 0 : agentInfo.network_status) === SENTINEL_ONE_NETWORK_STATUS.DISCONNECTED,
          lastSeen: (agentInfo === null || agentInfo === void 0 ? void 0 : agentInfo.last_active_date) || '',
          status: agentInfo !== null && agentInfo !== void 0 && agentInfo.is_active ? _types.HostStatus.HEALTHY :
          // If the agent is pending uninstall or uninstalled, we consider it unenrolled
          agentInfo !== null && agentInfo !== void 0 && agentInfo.is_pending_uninstall || agentInfo !== null && agentInfo !== void 0 && agentInfo.is_uninstalled ? _types.HostStatus.UNENROLLED : _types.HostStatus.OFFLINE,
          pendingActions: (_pendingActions$pendi = pendingActions === null || pendingActions === void 0 ? void 0 : pendingActions.pending_actions) !== null && _pendingActions$pendi !== void 0 ? _pendingActions$pendi : {}
        };
        return acc;
      }, {});
      this.log.debug(() => `Agent status response:\n${(0, _stringify.stringify)(response)}`);
      return response;
    } catch (err) {
      const error = new _errors.AgentStatusClientError(`Failed to fetch SentinelOne agent status for agentIds: [${agentIds}], failed with: ${err.message}`, 500, err);
      this.log.error(error);
      throw error;
    }
  }
}
exports.SentinelOneAgentStatusClient = SentinelOneAgentStatusClient;