"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogger = exports.getEndpointSuggestionsRequestHandler = void 0;
exports.registerEndpointSuggestionsRoutes = registerEndpointSuggestionsRoutes;
var _rxjs = require("rxjs");
var _server = require("@kbn/data-plugin/server");
var _terms_enum = require("@kbn/unified-search-plugin/server/autocomplete/terms_enum");
var _i18n = require("@kbn/i18n");
var _endpoint = require("../../../../common/api/endpoint");
var _constants = require("../../../../common/endpoint/constants");
var _with_endpoint_authz = require("../with_endpoint_authz");
var _error_handler = require("../error_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLogger = endpointAppContext => {
  return endpointAppContext.logFactory.get('suggestions');
};
exports.getLogger = getLogger;
function registerEndpointSuggestionsRoutes(router, config$, endpointContext, docLinks) {
  router.versioned.post({
    access: 'public',
    path: _constants.SUGGESTIONS_ROUTE,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    },
    options: {
      authRequired: true
    }
  }).addVersion({
    version: '2023-10-31',
    validate: {
      request: _endpoint.EndpointSuggestionsSchema
    },
    options: {
      deprecated: {
        documentationUrl: docLinks.links.securitySolution.legacyEndpointManagementApiDeprecations,
        severity: 'critical',
        message: _i18n.i18n.translate('xpack.securitySolution.deprecations.endpoint.suggestions', {
          defaultMessage: 'The "{path}" URL is deprecated and will be removed in the next major version.',
          values: {
            path: _constants.SUGGESTIONS_ROUTE
          }
        }),
        reason: {
          type: 'remove'
        }
      }
    }
  }, (0, _with_endpoint_authz.withEndpointAuthz)({
    any: ['canWriteEventFilters']
  }, endpointContext.logFactory.get('endpointSuggestions'), getEndpointSuggestionsRequestHandler(config$, getLogger(endpointContext))));
  router.versioned.post({
    access: 'internal',
    path: _constants.SUGGESTIONS_INTERNAL_ROUTE,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    },
    options: {
      authRequired: true
    }
  }).addVersion({
    version: '1',
    validate: {
      request: _endpoint.EndpointSuggestionsSchema
    }
  }, (0, _with_endpoint_authz.withEndpointAuthz)({
    any: ['canWriteEventFilters']
  }, endpointContext.logFactory.get('endpointSuggestions'), getEndpointSuggestionsRequestHandler(config$, getLogger(endpointContext))));
}
const getEndpointSuggestionsRequestHandler = (config$, logger) => {
  return async (context, request, response) => {
    const config = await (0, _rxjs.firstValueFrom)(config$);
    const {
      field: fieldName,
      query,
      filters,
      fieldMeta
    } = request.body;
    let index = '';
    if (request.params.suggestion_type === 'eventFilters') {
      index = _constants.eventsIndexPattern;
    } else {
      return response.badRequest({
        body: `Invalid suggestion_type: ${request.params.suggestion_type}`
      });
    }
    const abortSignal = (0, _server.getRequestAbortedSignal)(request.events.aborted$);
    const {
      savedObjects,
      elasticsearch
    } = await context.core;
    try {
      const body = await (0, _terms_enum.termsEnumSuggestions)(config, savedObjects.client, elasticsearch.client.asInternalUser, index, fieldName, query, filters, fieldMeta, abortSignal);
      return response.ok({
        body
      });
    } catch (error) {
      return (0, _error_handler.errorHandler)(logger, response, error);
    }
  };
};
exports.getEndpointSuggestionsRequestHandler = getEndpointSuggestionsRequestHandler;