"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timelinePrivilegesMiddleware = void 0;
var _i18n = require("@kbn/i18n");
var _actions = require("../actions");
var _timeline_capabilities = require("../../../common/utils/timeline_capabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isShowTimelineAction(action) {
  return action.type === _actions.showTimeline.type;
}
const timelinePrivilegesMiddleware = kibana => store => next => async action => {
  const {
    read: hasAccessToTimeline
  } = (0, _timeline_capabilities.extractTimelineCapabilities)(kibana.application.capabilities);
  if (isShowTimelineAction(action) && action.payload.show && !hasAccessToTimeline) {
    kibana.notifications.toasts.addWarning({
      title: _i18n.i18n.translate('xpack.securitySolution.timeline.toast.insufficientPrivileges.title', {
        defaultMessage: 'Insufficient privileges (timeline)'
      }),
      text: _i18n.i18n.translate('xpack.securitySolution.timeline.toast.insufficientPrivileges.text', {
        defaultMessage: 'You are trying to open a timeline but you do not have sufficient privileges. Please contact your administrator in order to get set up with the correct privileges for timeline.'
      })
    });
    return next((0, _actions.showTimeline)({
      id: action.payload.id,
      show: false
    }));
  } else {
    return next(action);
  }
};
exports.timelinePrivilegesMiddleware = timelinePrivilegesMiddleware;