"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFieldTableColumns = exports.FieldName = exports.Description = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("../../../../common/components/event_details/helpers");
var _empty_value = require("../../../../common/components/empty_value");
var _truncatable_text = require("../../../../common/components/truncatable_text");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TypeIcon = (0, _styledComponents.default)(_eui.EuiIcon)`
  margin: 0 4px;
  position: relative;
  top: -1px;
`;
TypeIcon.displayName = 'TypeIcon';
const Description = exports.Description = _styledComponents.default.span`
  user-select: text;
  width: ${({
  width
}) => width};
`;
Description.displayName = 'Description';
const FieldName = exports.FieldName = /*#__PURE__*/_react.default.memo(({
  fieldId,
  highlight = ''
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
  "data-test-subj": `field-${fieldId}-name`,
  search: highlight
}, fieldId)));
FieldName.displayName = 'FieldName';
const useFieldTableColumns = ({
  hasFieldEditPermission,
  openFieldEditor,
  openDeleteFieldModal
}) => {
  const getFieldTableColumns = (0, _react.useCallback)(({
    highlight,
    onHide
  }) => {
    const actions = hasFieldEditPermission ? [{
      name: i18n.EDIT,
      description: i18n.EDIT_DESCRIPTION,
      type: 'icon',
      icon: 'pencil',
      isPrimary: true,
      onClick: ({
        name
      }) => {
        openFieldEditor(name);
        onHide();
      },
      available: ({
        isRuntime
      }) => isRuntime,
      'data-test-subj': 'actionEditRuntimeField'
    }, {
      name: i18n.REMOVE,
      description: i18n.REMOVE_DESCRIPTION,
      type: 'icon',
      icon: 'trash',
      color: 'danger',
      isPrimary: true,
      onClick: ({
        name
      }) => {
        openDeleteFieldModal(name);
        onHide();
      },
      available: ({
        isRuntime
      }) => isRuntime,
      'data-test-subj': 'actionDeleteRuntimeField'
    }] : [];
    return [{
      field: 'name',
      name: i18n.NAME,
      render: (name, {
        type
      }) => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          alignItems: "center",
          gutterSize: "none"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: type
        }, /*#__PURE__*/_react.default.createElement(TypeIcon, {
          "data-test-subj": `field-${name}-icon`,
          type: (0, _helpers.getIconFromType)(type !== null && type !== void 0 ? type : null)
        }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(FieldName, {
          fieldId: name,
          highlight: highlight
        })));
      },
      sortable: true,
      width: '225px'
    }, {
      field: 'description',
      name: i18n.DESCRIPTION,
      render: (description, {
        name
      }) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: description
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
        "data-test-subj": "descriptionForScreenReaderOnly"
      }, /*#__PURE__*/_react.default.createElement("p", null, i18n.DESCRIPTION_FOR_FIELD(name))), /*#__PURE__*/_react.default.createElement(_truncatable_text.EllipsisText, null, /*#__PURE__*/_react.default.createElement(Description, {
        width: actions.length > 0 ? '335px' : '400px',
        "data-test-subj": `field-${name}-description`
      }, `${description !== null && description !== void 0 ? description : (0, _empty_value.getEmptyValue)()}`)))),
      sortable: true,
      width: actions.length > 0 ? '335px' : '400px'
    }, {
      field: 'isRuntime',
      name: i18n.RUNTIME,
      render: isRuntime => isRuntime ? /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: "success",
        title: i18n.RUNTIME_FIELD
      }) : null,
      sortable: true,
      width: '80px'
    }, {
      field: 'category',
      name: i18n.CATEGORY,
      render: (category, {
        name
      }) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        "data-test-subj": `field-${name}-category`
      }, category),
      sortable: true,
      width: '115px'
    }, ...(actions.length > 0 ? [{
      name: i18n.ACTIONS,
      actions,
      width: '80px'
    }] : [])];
  }, [hasFieldEditPermission, openFieldEditor, openDeleteFieldModal]);
  return getFieldTableColumns;
};
exports.useFieldTableColumns = useFieldTableColumns;