"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sourcererPaths = exports.showSourcererByPath = exports.getScopeFromPath = void 0;
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../../common/constants");
var _model = require("../store/model");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sourcererPaths = exports.sourcererPaths = [_constants.ALERTS_PATH, _constants.DATA_QUALITY_PATH, `${_constants.RULES_PATH}/id/:id`, _constants.HOSTS_PATH, _constants.USERS_PATH, _constants.NETWORK_PATH, _constants.OVERVIEW_PATH];
const detectionsPaths = [_constants.ALERTS_PATH, `${_constants.RULES_PATH}/id/:id`, `${_constants.CASES_PATH}/:detailName`, _constants.ATTACK_DISCOVERY_PATH];
const explorePaths = [_constants.HOSTS_PATH, _constants.USERS_PATH, _constants.NETWORK_PATH, _constants.OVERVIEW_PATH];
const getScopeFromPath = (pathname, newDataViewPickerEnabled) => {
  if ((0, _reactRouterDom.matchPath)(pathname, {
    path: detectionsPaths,
    strict: false
  })) {
    return _model.SourcererScopeName.detections;
  }
  if (newDataViewPickerEnabled && (0, _reactRouterDom.matchPath)(pathname, {
    path: explorePaths,
    strict: false
  })) {
    return _model.SourcererScopeName.explore;
  }
  return _model.SourcererScopeName.default;
};
exports.getScopeFromPath = getScopeFromPath;
const showSourcererByPath = pathname => (0, _reactRouterDom.matchPath)(pathname, {
  path: sourcererPaths,
  strict: false
}) != null;
exports.showSourcererByPath = showSourcererByPath;