"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrationNameInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MigrationNameInput = exports.MigrationNameInput = /*#__PURE__*/_react.default.memo(({
  migrationName,
  setMigrationName
}) => {
  const [name, setName] = (0, _react.useState)(migrationName);
  const handleNameChange = (0, _react.useCallback)(e => {
    setName(e.target.value);
  }, []);
  const handleNameSave = (0, _react.useCallback)(() => {
    setMigrationName(name);
  }, [name, setMigrationName]);
  const isInvalid = name.length === 0;
  const errors = (0, _react.useMemo)(() => {
    if (isInvalid) {
      return [i18n.MIGRATION_NAME_INPUT_ERROR];
    }
    return [];
  }, [isInvalid]);
  const onEnter = (0, _react.useCallback)(e => {
    if (e.key === 'Enter') {
      e.preventDefault();
      e.target.blur();
      handleNameSave();
    }
  }, [handleNameSave]);
  const onBlur = (0, _react.useCallback)(() => {
    handleNameSave();
  }, [handleNameSave]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    alignItems: "stretch"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: isInvalid,
    error: errors,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: i18n.MIGRATION_NAME_INPUT_DESCRIPTION,
    value: name,
    onChange: handleNameChange,
    isInvalid: isInvalid,
    onBlur: onBlur,
    onKeyDown: onEnter,
    fullWidth: true,
    autoFocus: true,
    "data-test-subj": "migrationNameInput"
  })))));
});
MigrationNameInput.displayName = 'MigrationNameInput';