"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyzerPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _details_panel = require("../../../resolver/view/details_panel");
var _panel_keys = require("../shared/constants/panel_keys");
var _constants = require("../preview/constants");
var _flyout_body = require("../../shared/components/flyout_body");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Displays node details panel for analyzer
 */
const AnalyzerPanel = ({
  resolverComponentInstanceID
}) => {
  const {
    openPreviewPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const openPreview = (0, _react.useCallback)(({
    documentId,
    indexName,
    scopeId,
    isAlert
  }) => () => {
    openPreviewPanel({
      id: _panel_keys.DocumentDetailsPreviewPanelKey,
      params: {
        id: documentId,
        indexName,
        scopeId,
        isPreviewMode: true,
        banner: isAlert ? _constants.ALERT_PREVIEW_BANNER : _constants.EVENT_PREVIEW_BANNER
      }
    });
  }, [openPreviewPanel]);
  return /*#__PURE__*/_react.default.createElement(_flyout_body.FlyoutBody, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      marginTop: '-15px'
    }
  }, /*#__PURE__*/_react.default.createElement(_details_panel.DetailsPanel, {
    resolverComponentInstanceID: resolverComponentInstanceID,
    nodeEventOnClick: openPreview
  })));
};
exports.AnalyzerPanel = AnalyzerPanel;
AnalyzerPanel.displayName = 'AnalyzerPanel';