"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setNetworkQueriesActivePageToZero = exports.setNetworkPageQueriesActivePageToZero = exports.setNetworkDetailsQueriesActivePageToZero = void 0;
var _model = require("./model");
var _constants = require("../../../common/store/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const setNetworkPageQueriesActivePageToZero = state => ({
  ...state.page.queries,
  [_model.NetworkTableType.topCountriesSource]: {
    ...state.page.queries[_model.NetworkTableType.topCountriesSource],
    activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
  },
  [_model.NetworkTableType.topCountriesDestination]: {
    ...state.page.queries[_model.NetworkTableType.topCountriesDestination],
    activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
  },
  [_model.NetworkTableType.topNFlowSource]: {
    ...state.page.queries[_model.NetworkTableType.topNFlowSource],
    activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
  },
  [_model.NetworkTableType.topNFlowDestination]: {
    ...state.page.queries[_model.NetworkTableType.topNFlowDestination],
    activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
  },
  [_model.NetworkTableType.dns]: {
    ...state.page.queries[_model.NetworkTableType.dns],
    activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
  },
  [_model.NetworkTableType.tls]: {
    ...state.page.queries[_model.NetworkTableType.tls],
    activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
  },
  [_model.NetworkTableType.http]: {
    ...state.page.queries[_model.NetworkTableType.http],
    activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
  }
});
exports.setNetworkPageQueriesActivePageToZero = setNetworkPageQueriesActivePageToZero;
const setNetworkDetailsQueriesActivePageToZero = state => ({
  ...state.details.queries,
  [_model.NetworkDetailsTableType.topCountriesSource]: {
    ...state.details.queries[_model.NetworkDetailsTableType.topCountriesSource],
    activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
  },
  [_model.NetworkDetailsTableType.topCountriesDestination]: {
    ...state.details.queries[_model.NetworkDetailsTableType.topCountriesDestination],
    activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
  },
  [_model.NetworkDetailsTableType.topNFlowSource]: {
    ...state.details.queries[_model.NetworkDetailsTableType.topNFlowSource],
    activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
  },
  [_model.NetworkDetailsTableType.topNFlowDestination]: {
    ...state.details.queries[_model.NetworkDetailsTableType.topNFlowDestination],
    activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
  },
  [_model.NetworkDetailsTableType.tls]: {
    ...state.details.queries[_model.NetworkDetailsTableType.tls],
    activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
  },
  [_model.NetworkDetailsTableType.users]: {
    ...state.details.queries[_model.NetworkDetailsTableType.users],
    activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
  },
  [_model.NetworkDetailsTableType.http]: {
    ...state.details.queries[_model.NetworkDetailsTableType.http],
    activePage: _constants.DEFAULT_TABLE_ACTIVE_PAGE
  }
});
exports.setNetworkDetailsQueriesActivePageToZero = setNetworkDetailsQueriesActivePageToZero;
const setNetworkQueriesActivePageToZero = (state, type) => {
  if (type === _model.NetworkType.page) {
    return setNetworkPageQueriesActivePageToZero(state);
  } else if (type === _model.NetworkType.details) {
    return setNetworkDetailsQueriesActivePageToZero(state);
  }
  throw new Error(`NetworkType ${type} is unknown`);
};
exports.setNetworkQueriesActivePageToZero = setNetworkQueriesActivePageToZero;