"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SEARCH_PLACEHOLDER = exports.EXPIRED_EXCEPTIONS = exports.EXCEPTION_SEARCH_ERROR_TITLE = exports.EXCEPTION_SEARCH_ERROR_BODY = exports.EXCEPTION_NO_SEARCH_RESULTS_PROMPT_TITLE = exports.EXCEPTION_NO_SEARCH_RESULTS_PROMPT_BODY = exports.EXCEPTION_ITEM_DELETE_TITLE = exports.EXCEPTION_ITEM_DELETE_TEXT = exports.EXCEPTION_ITEMS_PAGINATION_ARIA_LABEL = exports.EXCEPTION_ERROR_TITLE = exports.EXCEPTION_ERROR_DESCRIPTION = exports.EXCEPTION_EMPTY_PROMPT_TITLE = exports.EXCEPTION_EMPTY_PROMPT_ENDPOINT_BUTTON = exports.EXCEPTION_EMPTY_PROMPT_BUTTON = exports.EXCEPTION_EMPTY_PROMPT_BODY = exports.EXCEPTION_EMPTY_ENDPOINT_PROMPT_BODY = exports.EXCEPTION_DELETE_ERROR_TITLE = exports.EXCEPTIONS_TAB_ABOUT = exports.ENDPOINT_EXCEPTIONS_TAB_ABOUT = exports.ADD_TO_ENDPOINT_LIST = exports.ADD_TO_DETECTIONS_LIST = exports.ACTIVE_EXCEPTIONS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EXCEPTION_NO_SEARCH_RESULTS_PROMPT_TITLE = exports.EXCEPTION_NO_SEARCH_RESULTS_PROMPT_TITLE = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.allExceptionItems.noSearchResultsPromptTitle', {
  defaultMessage: 'No results match your search criteria'
});
const EXCEPTION_NO_SEARCH_RESULTS_PROMPT_BODY = exports.EXCEPTION_NO_SEARCH_RESULTS_PROMPT_BODY = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.allExceptionItems.noSearchResultsPromptBody', {
  defaultMessage: 'Try modifying your search.'
});
const EXCEPTION_EMPTY_PROMPT_TITLE = exports.EXCEPTION_EMPTY_PROMPT_TITLE = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.allExceptionItems.addExceptionsEmptyPromptTitle', {
  defaultMessage: 'Add exceptions to this rule'
});
const EXCEPTION_EMPTY_PROMPT_BODY = exports.EXCEPTION_EMPTY_PROMPT_BODY = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.allExceptionItems.emptyPromptBody', {
  defaultMessage: 'There are no exceptions for this rule. Create your first rule exception.'
});
const EXCEPTION_EMPTY_ENDPOINT_PROMPT_BODY = exports.EXCEPTION_EMPTY_ENDPOINT_PROMPT_BODY = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.allExceptionItems.endpoint.emptyPromptBody', {
  defaultMessage: 'There are no endpoint exceptions. Create your first endpoint exception.'
});
const EXCEPTION_EMPTY_PROMPT_BUTTON = exports.EXCEPTION_EMPTY_PROMPT_BUTTON = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.allExceptionItems.emptyPromptButtonLabel', {
  defaultMessage: 'Add rule exception'
});
const EXCEPTION_EMPTY_PROMPT_ENDPOINT_BUTTON = exports.EXCEPTION_EMPTY_PROMPT_ENDPOINT_BUTTON = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.allExceptionItems.endpoint.emptyPromptButtonLabel', {
  defaultMessage: 'Add endpoint exception'
});
const EXCEPTION_ERROR_TITLE = exports.EXCEPTION_ERROR_TITLE = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.allExceptionItems.exceptionItemsFetchError', {
  defaultMessage: 'Unable to load exception items'
});
const EXCEPTION_ERROR_DESCRIPTION = exports.EXCEPTION_ERROR_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.allExceptionItems.exceptionItemsFetchErrorDescription', {
  defaultMessage: 'There was an error loading the exception items. Contact your administrator for help.'
});
const EXCEPTION_SEARCH_ERROR_TITLE = exports.EXCEPTION_SEARCH_ERROR_TITLE = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.allExceptionItems.exceptionItemSearchErrorTitle', {
  defaultMessage: 'Error searching'
});
const EXCEPTION_SEARCH_ERROR_BODY = exports.EXCEPTION_SEARCH_ERROR_BODY = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.allExceptionItems.exceptionItemSearchErrorBody', {
  defaultMessage: 'An error occurred searching for exception items. Please try again.'
});
const EXCEPTION_DELETE_ERROR_TITLE = exports.EXCEPTION_DELETE_ERROR_TITLE = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.allExceptionItems.exceptionDeleteErrorTitle', {
  defaultMessage: 'Error deleting exception item'
});
const EXCEPTION_ITEMS_PAGINATION_ARIA_LABEL = exports.EXCEPTION_ITEMS_PAGINATION_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.allExceptionItems.paginationAriaLabel', {
  defaultMessage: 'Exception item table pagination'
});
const EXCEPTION_ITEM_DELETE_TITLE = exports.EXCEPTION_ITEM_DELETE_TITLE = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.allExceptionItems.exceptionItemDeleteSuccessTitle', {
  defaultMessage: 'Exception deleted'
});
const EXCEPTION_ITEM_DELETE_TEXT = itemName => _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.allExceptionItems.exceptionItemDeleteSuccessText', {
  values: {
    itemName
  },
  defaultMessage: '"{itemName}" deleted successfully.'
});
exports.EXCEPTION_ITEM_DELETE_TEXT = EXCEPTION_ITEM_DELETE_TEXT;
const ENDPOINT_EXCEPTIONS_TAB_ABOUT = exports.ENDPOINT_EXCEPTIONS_TAB_ABOUT = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.allExceptionItems.exceptionEndpointDetailsDescription', {
  defaultMessage: 'Endpoint exceptions are added to both the detection rule and the Elastic Endpoint agent on your hosts.'
});
const EXCEPTIONS_TAB_ABOUT = exports.EXCEPTIONS_TAB_ABOUT = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.allExceptionItems.exceptionDetectionDetailsDescription', {
  defaultMessage: 'Rule exceptions are added to the detection rule.'
});
const SEARCH_PLACEHOLDER = exports.SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.allExceptionItems.searchPlaceholder', {
  defaultMessage: 'Filter exceptions using simple query syntax, for example, name:"my list"'
});
const ADD_TO_ENDPOINT_LIST = exports.ADD_TO_ENDPOINT_LIST = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.allExceptionItems.addToEndpointListLabel', {
  defaultMessage: 'Add endpoint exception'
});
const ADD_TO_DETECTIONS_LIST = exports.ADD_TO_DETECTIONS_LIST = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.allExceptionItems.addToDetectionsListLabel', {
  defaultMessage: 'Add rule exception'
});
const ACTIVE_EXCEPTIONS = exports.ACTIVE_EXCEPTIONS = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.allExceptionItems.activeDetectionsLabel', {
  defaultMessage: 'Active exceptions'
});
const EXPIRED_EXCEPTIONS = exports.EXPIRED_EXCEPTIONS = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.allExceptionItems.expiredDetectionsLabel', {
  defaultMessage: 'Expired exceptions'
});