"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sourceOrDestinationIpExistsFilter = exports.parseVisualizationData = exports.getRequestsAndResponses = exports.getNetworkDetailsPageFilter = exports.getIndexFilters = exports.getDetailsPageFilter = exports.fieldNameExistsFilter = exports.VISUALIZATION_ACTIONS_BUTTON_CLASS = exports.FILTER_OUT_LEGEND_ACTION = exports.FILTER_IN_LEGEND_ACTION = void 0;
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VISUALIZATION_ACTIONS_BUTTON_CLASS = exports.VISUALIZATION_ACTIONS_BUTTON_CLASS = 'histogram-actions-trigger';
const FILTER_IN_LEGEND_ACTION = exports.FILTER_IN_LEGEND_ACTION = `filterIn`;
const FILTER_OUT_LEGEND_ACTION = exports.FILTER_OUT_LEGEND_ACTION = `filterOut`;
const pageFilterFieldMap = {
  [_constants.SecurityPageName.hosts]: 'host',
  [_constants.SecurityPageName.users]: 'user'
};
const getDetailsPageFilter = (pageName, detailName) => {
  const field = pageFilterFieldMap[pageName];
  return field && detailName ? [{
    meta: {
      alias: null,
      negate: false,
      disabled: false,
      type: 'phrase',
      key: `${field}.name`,
      params: {
        query: detailName
      }
    },
    query: {
      match_phrase: {
        [`${field}.name`]: detailName
      }
    }
  }] : [];
};
exports.getDetailsPageFilter = getDetailsPageFilter;
const fieldNameExistsFilter = pageName => {
  const field = pageFilterFieldMap[pageName];
  return field && pageName ? [{
    query: {
      bool: {
        should: [{
          exists: {
            field: `${field}.name`
          }
        }],
        minimum_should_match: 1
      }
    },
    meta: {
      alias: '',
      disabled: false,
      key: 'bool',
      negate: false,
      type: 'custom',
      value: `{"query": {"bool": {"filter": [{"bool": {"should": [{"exists": {"field": "${field}.name"}}],"minimum_should_match": 1}}]}}}`
    }
  }] : [];
};
exports.fieldNameExistsFilter = fieldNameExistsFilter;
const getNetworkDetailsPageFilter = ipAddress => ipAddress ? [{
  meta: {
    alias: null,
    negate: false,
    disabled: false,
    type: 'phrase',
    key: 'source.ip',
    params: {
      query: ipAddress
    }
  },
  query: {
    bool: {
      should: [{
        match_phrase: {
          'source.ip': ipAddress
        }
      }, {
        match_phrase: {
          'destination.ip': ipAddress
        }
      }],
      minimum_should_match: 1
    }
  }
}] : [];
exports.getNetworkDetailsPageFilter = getNetworkDetailsPageFilter;
const sourceOrDestinationIpExistsFilter = exports.sourceOrDestinationIpExistsFilter = [{
  query: {
    bool: {
      should: [{
        exists: {
          field: 'source.ip'
        }
      }, {
        exists: {
          field: 'destination.ip'
        }
      }],
      minimum_should_match: 1
    }
  },
  meta: {
    alias: '',
    disabled: false,
    key: 'bool',
    negate: false,
    type: 'custom',
    value: '{"bool":{"filter":[{"bool":{"should":[{"bool":{"should":[{"exists":{"field": "source.ip"}}],"minimum_should_match":1}},{"bool":{"should":[{"exists":{"field": "destination.ip"}}],"minimum_should_match":1}}],"minimum_should_match":1}}]}}'
  }
}];
const getIndexFilters = selectedPatterns => selectedPatterns.length >= 1 ? [{
  meta: {
    type: 'phrases',
    key: '_index',
    params: selectedPatterns,
    alias: null,
    negate: false,
    disabled: false
  },
  query: {
    bool: {
      should: selectedPatterns.map(selectedPattern => ({
        match_phrase: {
          _index: selectedPattern
        }
      })),
      minimum_should_match: 1
    }
  }
}] : [];
exports.getIndexFilters = getIndexFilters;
const getRequestsAndResponses = requests => {
  return (requests !== null && requests !== void 0 ? requests : []).reduce((acc, req) => {
    var _req$stats$indexFilte, _req$stats, _req$stats$indexFilte2, _req$response$json$ra, _req$response, _req$response$json;
    return {
      requests: [...acc.requests, JSON.stringify({
        body: req === null || req === void 0 ? void 0 : req.json,
        index: ((_req$stats$indexFilte = req === null || req === void 0 ? void 0 : (_req$stats = req.stats) === null || _req$stats === void 0 ? void 0 : (_req$stats$indexFilte2 = _req$stats.indexFilter) === null || _req$stats$indexFilte2 === void 0 ? void 0 : _req$stats$indexFilte2.value) !== null && _req$stats$indexFilte !== void 0 ? _req$stats$indexFilte : '').split(',')
      }, null, 2)],
      responses: [...acc.responses, JSON.stringify((_req$response$json$ra = req === null || req === void 0 ? void 0 : (_req$response = req.response) === null || _req$response === void 0 ? void 0 : (_req$response$json = _req$response.json) === null || _req$response$json === void 0 ? void 0 : _req$response$json.rawResponse) !== null && _req$response$json$ra !== void 0 ? _req$response$json$ra : {}, null, 2)]
    };
  }, {
    requests: [],
    responses: []
  });
};
exports.getRequestsAndResponses = getRequestsAndResponses;
const parseVisualizationData = data => data.reduce((acc, curr) => {
  try {
    return [...acc, JSON.parse(curr)];
  } catch (e) {
    return acc;
  }
}, []);
exports.parseVisualizationData = parseVisualizationData;