"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMissingPrivilegesErrorMessage = exports.getAllMissingPrivileges = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAllMissingPrivileges = privilege => {
  var _esPrivileges$index;
  const esPrivileges = privilege.privileges.elasticsearch;
  const kbnPrivileges = privilege.privileges.kibana;
  const index = Object.entries((_esPrivileges$index = esPrivileges.index) !== null && _esPrivileges$index !== void 0 ? _esPrivileges$index : {}).map(([indexName, indexPrivileges]) => ({
    indexName,
    privileges: filterUnauthorized(indexPrivileges)
  })).filter(({
    privileges
  }) => privileges.length > 0);
  return {
    elasticsearch: {
      index,
      cluster: filterUnauthorized(esPrivileges.cluster)
    },
    kibana: filterUnauthorized(kbnPrivileges)
  };
};
exports.getAllMissingPrivileges = getAllMissingPrivileges;
const getMissingPrivilegesErrorMessage = ({
  elasticsearch,
  kibana
}) => [...elasticsearch.index.map(({
  indexName,
  privileges
}) => `Missing [${privileges.join(', ')}] privileges for index '${indexName}'.`), ...(elasticsearch.cluster.length > 0 ? [`Missing [${elasticsearch.cluster.join(', ')}] cluster privileges.`] : []), ...(kibana.length > 0 ? [`Missing [${kibana.join(', ')}] Kibana privileges.`] : [])].join('\n');
exports.getMissingPrivilegesErrorMessage = getMissingPrivilegesErrorMessage;
const filterUnauthorized = obj => Object.entries(obj !== null && obj !== void 0 ? obj : {}).filter(([_, authorized]) => !authorized).map(([privileges, _]) => privileges);