"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineUpdateApiKeyRoutes = defineUpdateApiKeyRoutes;
var _configSchema = require("@kbn/config-schema");
var _securityPluginTypesServer = require("@kbn/security-plugin-types-server");
var _api_keys = require("../../authentication/api_keys/api_keys");
var _errors = require("../../errors");
var _licensed_route_handler = require("../licensed_route_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function defineUpdateApiKeyRoutes({
  router,
  authz,
  getAuthenticationService
}) {
  const bodySchemaWithKibanaPrivileges = (0, _securityPluginTypesServer.getUpdateRestApiKeyWithKibanaPrivilegesSchema)(() => {
    const privileges = authz.privileges.get();
    return {
      global: Object.keys(privileges.global),
      space: Object.keys(privileges.space)
    };
  });
  router.put({
    path: '/internal/security/api_key',
    security: {
      authz: {
        enabled: false,
        reason: `This route delegates authorization to the scoped ES cluster client of the internal authentication service`
      }
    },
    validate: {
      body: _configSchema.schema.oneOf([_securityPluginTypesServer.updateRestApiKeySchema, _securityPluginTypesServer.updateCrossClusterApiKeySchema, bodySchemaWithKibanaPrivileges])
    },
    options: {
      access: 'internal'
    }
  }, (0, _licensed_route_handler.createLicensedRouteHandler)(async (context, request, response) => {
    try {
      const result = await getAuthenticationService().apiKeys.update(request, request.body);
      if (result === null) {
        return response.badRequest({
          body: {
            message: `API Keys are not available`
          }
        });
      }
      return response.ok({
        body: result
      });
    } catch (error) {
      if (error instanceof _api_keys.UpdateApiKeyValidationError) {
        return response.badRequest({
          body: {
            message: error.message
          }
        });
      }
      return response.customError((0, _errors.wrapIntoCustomErrorResponse)(error));
    }
  }));
}