"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getChatParams = void 0;
var _constants = require("@kbn/stack-connectors-plugin/common/openai/constants");
var _constants2 = require("@kbn/stack-connectors-plugin/common/bedrock/constants");
var _constants3 = require("@kbn/stack-connectors-plugin/common/gemini/constants");
var _constants4 = require("@kbn/stack-connectors-plugin/common/inference/constants");
var _server = require("@kbn/langchain/server");
var _prompt = require("../../common/prompt");
var _eis = require("../utils/eis");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getChatParams = async ({
  connectorId,
  model,
  prompt,
  citations
}, {
  actions,
  inference,
  request
}) => {
  var _connector$config3, _connector$config4;
  let summarizationModel = model;
  const actionsClient = await actions.getActionsClientWithRequest(request);
  const connector = await actionsClient.get({
    id: connectorId
  });
  let llmType;
  let modelType;
  switch (connector.actionTypeId) {
    case _constants4.INFERENCE_CONNECTOR_ID:
      if ((0, _eis.isEISConnector)(connector)) {
        var _connector$config, _connector$config$pro;
        if (!summarizationModel && (_connector$config = connector.config) !== null && _connector$config !== void 0 && (_connector$config$pro = _connector$config.providerConfig) !== null && _connector$config$pro !== void 0 && _connector$config$pro.model_id) {
          var _connector$config2, _connector$config2$pr;
          summarizationModel = (_connector$config2 = connector.config) === null || _connector$config2 === void 0 ? void 0 : (_connector$config2$pr = _connector$config2.providerConfig) === null || _connector$config2$pr === void 0 ? void 0 : _connector$config2$pr.model_id;
        }
      }
      llmType = 'inference';
      modelType = 'openai';
      break;
    case _constants.OPENAI_CONNECTOR_ID:
      llmType = 'openai';
      modelType = 'openai';
      break;
    case _constants2.BEDROCK_CONNECTOR_ID:
      llmType = 'bedrock';
      modelType = 'anthropic';
      break;
    case _constants3.GEMINI_CONNECTOR_ID:
      llmType = 'gemini';
      modelType = 'gemini';
      break;
    default:
      throw new Error(`Invalid connector type: ${connector.actionTypeId}`);
  }
  const chatPrompt = (0, _prompt.Prompt)(prompt, {
    citations,
    context: true,
    type: modelType
  });
  const questionRewritePrompt = (0, _prompt.QuestionRewritePrompt)({
    type: modelType
  });
  const chatModel = await inference.getChatModel({
    request,
    connectorId,
    chatModelOptions: {
      model: summarizationModel || (connector === null || connector === void 0 ? void 0 : (_connector$config3 = connector.config) === null || _connector$config3 === void 0 ? void 0 : _connector$config3.defaultModel),
      temperature: (0, _server.getDefaultArguments)(llmType).temperature,
      // prevents the agent from retrying on failure
      // failure could be due to bad connector, we should deliver that result to the client asap
      maxRetries: 0,
      telemetryMetadata: {
        pluginId: 'search_playground'
      } // hard-coded because the pluginId is not snake cased and the telemetry expects snake case
    }
  });
  return {
    chatModel,
    chatPrompt,
    questionRewritePrompt,
    connector,
    summarizationModel: summarizationModel || (connector === null || connector === void 0 ? void 0 : (_connector$config4 = connector.config) === null || _connector$config4 === void 0 ? void 0 : _connector$config4.defaultModel)
  };
};
exports.getChatParams = getChatParams;