"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePageChrome = void 0;
var _react = require("react");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePageChrome = (docTitle, breadcrumbs) => {
  const {
    chrome,
    http,
    serverless
  } = (0, _use_kibana.useKibana)().services;
  (0, _react.useEffect)(() => {
    chrome.docTitle.change(docTitle);
    const newBreadcrumbs = breadcrumbs.map(breadcrumb => {
      if (breadcrumb.href && http.basePath.get().length > 0) {
        breadcrumb.href = http.basePath.prepend(breadcrumb.href);
      }
      return breadcrumb;
    });
    if (serverless) {
      serverless.setBreadcrumbs(newBreadcrumbs);
    } else {
      chrome.setBreadcrumbs(newBreadcrumbs);
    }
    return () => {
      // clear manually set breadcrumbs
      if (serverless) {
        serverless.setBreadcrumbs([]);
      } else {
        chrome.setBreadcrumbs([]);
      }
    };
  }, [breadcrumbs, chrome, docTitle, http.basePath, serverless]);
};
exports.usePageChrome = usePageChrome;