"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteDocument = void 0;
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../../constants");
var _use_kibana = require("../use_kibana");
var _use_document_search = require("./use_document_search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDeleteDocument = indexName => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const queryClient = (0, _reactQuery.useQueryClient)();
  const result = (0, _reactQuery.useMutation)(async ({
    id
  }) => {
    const response = await http.delete(`/internal/search_indices/${indexName}/documents/${id}`);
    return response.acknowledged;
  }, {
    mutationKey: [_constants.MutationKeys.SearchIndicesDeleteDocument, indexName],
    onMutate: async ({
      id
    }) => {
      await queryClient.cancelQueries([_constants.QueryKeys.SearchDocuments, indexName]);
      const previousData = queryClient.getQueryData([_constants.QueryKeys.SearchDocuments, indexName]);
      queryClient.setQueryData([_constants.QueryKeys.SearchDocuments, indexName], snapshot => {
        const oldData = snapshot !== null && snapshot !== void 0 ? snapshot : {
          results: {
            data: [],
            _meta: {
              page: {
                total: 0
              }
            }
          }
        };
        return {
          ...oldData,
          results: {
            ...oldData.results,
            data: oldData.results.data.filter(doc => doc._id !== id),
            _meta: {
              page: {
                ...oldData.results._meta.page,
                total: oldData.results._meta.page.total - 1
              }
            }
          }
        };
      });
      return {
        previousData
      };
    },
    onSuccess: () => {
      setTimeout(() => {
        queryClient.invalidateQueries([_constants.QueryKeys.SearchDocuments, indexName]);
      }, _use_document_search.INDEX_SEARCH_POLLING);
    },
    onError: (error, _, context) => {
      if (context !== null && context !== void 0 && context.previousData) {
        queryClient.setQueryData([_constants.QueryKeys.SearchDocuments, indexName], context.previousData);
      }
      return error;
    }
  });
  return {
    ...result
  };
};
exports.useDeleteDocument = useDeleteDocument;