"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JavascriptServerlessCreateIndexExamples = exports.JSServerlessIngestVectorDataExample = exports.JAVASCRIPT_INFO = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JAVASCRIPT_INFO = exports.JAVASCRIPT_INFO = {
  id: 'javascript',
  title: _i18n.i18n.translate('xpack.searchIndices.codingLanguages.javascript', {
    defaultMessage: 'Javascript'
  }),
  icon: 'javascript.svg',
  codeBlockLanguage: 'javascript'
};
const SERVERLESS_INSTALL_CMD = `npm install @elastic/elasticsearch`;
const JavascriptServerlessCreateIndexExamples = exports.JavascriptServerlessCreateIndexExamples = {
  default: {
    installCommand: SERVERLESS_INSTALL_CMD,
    createIndex: ({
      elasticsearchURL,
      apiKey,
      indexName
    }) => `import { Client } from "@elastic/elasticsearch"

const client = new Client({
  node: '${elasticsearchURL}',
  auth: {
    apiKey: "${apiKey !== null && apiKey !== void 0 ? apiKey : _constants.API_KEY_PLACEHOLDER}"
  }
});

client.indices.create({
  index: "${indexName !== null && indexName !== void 0 ? indexName : _constants.INDEX_PLACEHOLDER}",
});`
  },
  dense_vector: {
    installCommand: SERVERLESS_INSTALL_CMD,
    createIndex: ({
      elasticsearchURL,
      apiKey,
      indexName
    }) => `import { Client } from "@elastic/elasticsearch"

const client = new Client({
  node: '${elasticsearchURL}',
  auth: {
    apiKey: "${apiKey !== null && apiKey !== void 0 ? apiKey : _constants.API_KEY_PLACEHOLDER}"
  }
});

client.indices.create({
  index: "${indexName !== null && indexName !== void 0 ? indexName : _constants.INDEX_PLACEHOLDER}",
  mappings: {
    properties: {
      vector: { type: "dense_vector", dims: 3 },
      text: { type: "text"}
    },
  },
});`
  }
};
const JSServerlessIngestVectorDataExample = exports.JSServerlessIngestVectorDataExample = {
  installCommand: SERVERLESS_INSTALL_CMD,
  ingestCommand: ({
    apiKey,
    elasticsearchURL,
    sampleDocuments,
    indexName
  }) => `import { Client } from "@elastic/elasticsearch";

const client = new Client({
  node: '${elasticsearchURL}',
  auth: {
    apiKey: "${apiKey !== null && apiKey !== void 0 ? apiKey : _constants.API_KEY_PLACEHOLDER}"
  },
});

const index = "${indexName}";
const docs = ${JSON.stringify(sampleDocuments, null, 2)};

const bulkIngestResponse = await client.helpers.bulk({
  index,
  datasource: docs,
  onDocument() {
    return {
      index: {},
    };
  }
});
console.log(bulkIngestResponse);`,
  updateMappingsCommand: ({
    apiKey,
    elasticsearchURL,
    indexName,
    mappingProperties
  }) => `import { Client } from "@elastic/elasticsearch";

const client = new Client({
node: '${elasticsearchURL}',
auth: {
  apiKey: "${apiKey !== null && apiKey !== void 0 ? apiKey : _constants.API_KEY_PLACEHOLDER}"
}
});

const index = "${indexName}";
const mapping = ${JSON.stringify(mappingProperties, null, 2)};

const updateMappingResponse = await client.indices.putMapping({
  index,
  properties: mapping,
});
console.log(updateMappingResponse);`
};