"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNavMenu = TopNavMenu;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _top_nav_menu_items = require("./top_nav_menu_items");
var _top_nav_menu_badges = require("./top_nav_menu_badges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/*
 * Top Nav Menu is a convenience wrapper component for:
 * - Top navigation menu - configured by an array of `TopNavMenuData` objects
 * - Search Bar - which includes Filter Bar \ Query Input \ Timepicker.
 *
 * See SearchBar documentation to learn more about its properties.
 *
 **/

function TopNavMenu(props) {
  const {
    config,
    badges,
    showSearchBar,
    ...searchBarProps
  } = props;
  if ((!config || config.length === 0) && (!showSearchBar || !props.unifiedSearch)) {
    return null;
  }
  function renderBadges() {
    return /*#__PURE__*/_react.default.createElement(_top_nav_menu_badges.TopNavMenuBadges, {
      badges: badges
    });
  }
  function renderMenu(className) {
    return /*#__PURE__*/_react.default.createElement(_top_nav_menu_items.TopNavMenuItems, {
      config: config,
      className: className,
      popoverBreakpoints: props.popoverBreakpoints
    });
  }
  function renderSearchBar() {
    // Validate presence of all required fields
    if (!showSearchBar || !props.unifiedSearch) return null;
    const {
      AggregateQuerySearchBar
    } = props.unifiedSearch.ui;
    return /*#__PURE__*/_react.default.createElement(AggregateQuerySearchBar, searchBarProps);
  }
  function renderLayout() {
    const {
      setMenuMountPoint,
      visible
    } = props;
    const menuClassName = (0, _classnames.default)('kbnTopNavMenu', props.className);
    const wrapperClassName = (0, _classnames.default)('kbnTopNavMenu__wrapper', {
      'kbnTopNavMenu__wrapper--hidden': visible === false
    });
    if (setMenuMountPoint) {
      const badgesEl = renderBadges();
      const menuEl = renderMenu(menuClassName);
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (badgesEl || menuEl) && /*#__PURE__*/_react.default.createElement(_reactKibanaMount.MountPointPortal, {
        setMountPoint: setMenuMountPoint
      }, /*#__PURE__*/_react.default.createElement("span", {
        className: `${wrapperClassName} kbnTopNavMenu__badgeWrapper`
      }, badgesEl, menuEl)), renderSearchBar());
    } else {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
        className: wrapperClassName
      }, renderMenu(menuClassName)), renderSearchBar());
    }
  }
  return renderLayout();
}
TopNavMenu.defaultProps = {
  showSearchBar: false,
  showQueryInput: true,
  showDatePicker: true,
  showFilterBar: true,
  screenTitle: ''
};