"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaPanel = KibanaPanel;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../../common/constants");
var _enums = require("../../../../common/enums");
var _badge = require("../../../alerts/badge");
var _should_show_alert_badge = require("../../../alerts/lib/should_show_alert_badge");
var _external_config_context = require("../../../application/contexts/external_config_context");
var _format_number = require("../../../lib/format_number");
var _get_safe_for_external_link = require("../../../lib/get_safe_for_external_link");
var _setup_mode = require("../../../lib/setup_mode");
var _setup_mode_context = require("../../setup_mode/setup_mode_context");
var _tooltip = require("../../setup_mode/tooltip");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INSTANCES_PANEL_ALERTS = [_constants.RULE_KIBANA_VERSION_MISMATCH];
function KibanaPanel(props) {
  const setupMode = props.setupMode;
  const alerts = props.alerts;
  const setupModeContext = _react.default.useContext(_setup_mode_context.SetupModeContext);
  const {
    staleStatusThresholdSeconds
  } = _react.default.useContext(_external_config_context.ExternalConfigContext);
  const showDetectedKibanas = setupMode.enabled && (0, _lodash.get)(setupMode.data, 'kibana.detected.doesExist', false);
  if (!props.count && !showDetectedKibanas) {
    return null;
  }
  const goToKibana = () => (0, _get_safe_for_external_link.getSafeForExternalLink)('#/kibana');
  const goToInstances = () => (0, _get_safe_for_external_link.getSafeForExternalLink)('#/kibana/instances');
  const setupModeData = (0, _lodash.get)(setupMode.data, 'kibana');
  const setupModeMetricbeatMigrationTooltip = (0, _setup_mode.isSetupModeFeatureEnabled)(_enums.SetupModeFeature.MetricbeatMigration) ? /*#__PURE__*/_react.default.createElement(_tooltip.SetupModeTooltip, {
    setupModeData: setupModeData,
    productName: _constants.KIBANA_SYSTEM_ID,
    badgeClickLink: goToInstances()
  }) : null;
  let instancesAlertStatus = null;
  if ((0, _should_show_alert_badge.shouldShowAlertBadge)(alerts, INSTANCES_PANEL_ALERTS, setupModeContext)) {
    const alertsList = INSTANCES_PANEL_ALERTS.map(alertType => alerts[alertType]);
    instancesAlertStatus = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_badge.AlertsBadge, {
      alerts: alertsList
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_helpers.ClusterItemContainer, (0, _extends2.default)({}, props, {
    statusIndicator: statusIndicator(props.status, props.some_status_is_stale, goToInstances(), staleStatusThresholdSeconds),
    url: "kibana",
    title: _i18n.i18n.translate('xpack.monitoring.cluster.overview.kibanaPanel.kibanaTitle', {
      defaultMessage: 'Kibana'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 4
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_helpers.DisabledIfNoDataAndInSetupModeLink, {
    setupModeEnabled: setupMode.enabled,
    setupModeData: setupModeData,
    href: goToKibana(),
    "aria-label": _i18n.i18n.translate('xpack.monitoring.cluster.overview.kibanaPanel.overviewLinkAriaLabel', {
      defaultMessage: 'Kibana Overview'
    }),
    "data-test-subj": "kbnOverview"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.kibanaPanel.overviewLinkLabel",
    defaultMessage: "Overview"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    "data-test-subj": "kibana_overview",
    "data-overview-status": props.status
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.kibanaPanel.requestsLabel",
    defaultMessage: "Requests"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "kbnRequests"
  }, props.requests_total), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.kibanaPanel.maxResponseTimeLabel",
    defaultMessage: "Max. Response Time"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "kbnMaxResponseTime"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.kibanaPanel.maxResponseTimeDescription",
    defaultMessage: "{maxTime} ms",
    values: {
      maxTime: props.response_time_max
    }
  })), props.rules.instance && props.rules.cluster && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.kibanaPanel.ruleFailuresLabel",
    defaultMessage: "Rule Success Ratio"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "kbnRuleFailures"
  }, (0, _format_number.formatPercentageUsage)(props.rules.instance.executions - props.rules.instance.failures, props.rules.instance.executions)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.kibanaPanel.queuedRulesCountLabel",
    defaultMessage: "Queued Rules"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "kbnQueuedRules"
  }, props.rules.cluster.overdue.count))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: goToInstances(),
    "data-test-subj": "kbnInstances",
    "aria-label": _i18n.i18n.translate('xpack.monitoring.cluster.overview.kibanaPanel.instancesCountLinkAriaLabel', {
      defaultMessage: 'Kibana Instances: {instancesCount}',
      values: {
        instancesCount: props.count
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.kibanaPanel.instancesCountLinkLabel",
    defaultMessage: "Instances: {instancesCount}",
    values: {
      instancesCount: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "number_of_kibana_instances"
      }, props.count)
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, setupModeMetricbeatMigrationTooltip, instancesAlertStatus))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.kibanaPanel.connectionsLabel",
    defaultMessage: "Connections"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "kbnConnections"
  }, (0, _format_number.formatNumber)(props.concurrent_connections, 'int_commas')), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "eui-textBreakWord"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.cluster.overview.kibanaPanel.memoryUsageLabel",
    defaultMessage: "Memory Usage"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "kbnMemoryUsage"
  }, /*#__PURE__*/_react.default.createElement(_helpers.BytesPercentageUsage, {
    usedBytes: props.memory_size,
    maxBytes: props.memory_limit
  })))))));
}
function statusIndicator(status, someStatusIsStale, instancesHref, staleStatusThresholdSeconds) {
  if (!someStatusIsStale) {
    return /*#__PURE__*/_react.default.createElement(_helpers.HealthStatusIndicator, {
      status: status,
      product: 'kb'
    });
  }
  const staleMessage = _i18n.i18n.translate('xpack.monitoring.cluster.overview.kibanaPanel.staleStatusTooltip', {
    defaultMessage: "It's been more than {staleStatusThresholdSeconds} seconds since we have heard from some instances.",
    values: {
      staleStatusThresholdSeconds
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      marginBottom: '8px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: staleMessage
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: "warning",
    color: "warning",
    "data-test-subj": "status"
  }, _i18n.i18n.translate('xpack.monitoring.cluster.overview.kibanaPanel.staleStatusLabel', {
    defaultMessage: 'Stale'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: instancesHref
  }, _i18n.i18n.translate('xpack.monitoring.cluster.overview.kibanaPanel.staleStatusLinkToInstancesLabel', {
    defaultMessage: 'View all instances'
  })));
}