"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertParamPercentage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertParamPercentage = props => {
  const {
    name,
    label,
    setRuleParams,
    errors
  } = props;
  const [value, setValue] = _react.default.useState(props.percentage);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    error: errors,
    isInvalid: errors.length > 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    compressed: true,
    value: value,
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("strong", null, "%")),
    onChange: e => {
      let newValue = parseInt(e.target.value, 10);
      if (isNaN(newValue)) {
        newValue = 0;
      }
      setValue(newValue);
      setRuleParams(name, newValue);
    }
  }));
};
exports.AlertParamPercentage = AlertParamPercentage;