"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewJobCapabilitiesServiceBase = void 0;
exports.processTextAndKeywordFields = processTextAndKeywordFields;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _fieldTypes = require("@kbn/field-types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// create two lists, one removing text fields if there are keyword equivalents and vice versa
function processTextAndKeywordFields(fields) {
  const keywordIds = fields.filter(f => f.type === _fieldTypes.ES_FIELD_TYPES.KEYWORD).map(f => f.id);
  const textIds = fields.filter(f => f.type === _fieldTypes.ES_FIELD_TYPES.TEXT).map(f => f.id);
  const fieldsPreferringKeyword = fields.filter(f => f.type !== _fieldTypes.ES_FIELD_TYPES.TEXT || f.type === _fieldTypes.ES_FIELD_TYPES.TEXT && keywordIds.includes(`${f.id}.keyword`) === false);
  const fieldsPreferringText = fields.filter(f => f.type !== _fieldTypes.ES_FIELD_TYPES.KEYWORD || f.type === _fieldTypes.ES_FIELD_TYPES.KEYWORD && textIds.includes(f.id.replace(/\.keyword$/, '')) === false);
  return {
    fieldsPreferringKeyword,
    fieldsPreferringText
  };
}
class NewJobCapabilitiesServiceBase {
  constructor() {
    (0, _defineProperty2.default)(this, "_fields", void 0);
    (0, _defineProperty2.default)(this, "_aggs", void 0);
    this._fields = [];
    this._aggs = [];
  }
  get fields() {
    return this._fields;
  }
  get aggs() {
    return this._aggs;
  }
  get newJobCaps() {
    return {
      fields: this._fields,
      aggs: this._aggs
    };
  }
  getFieldById(id) {
    const field = this._fields.find(f => f.id === id);
    return field === undefined ? null : field;
  }
  getAggById(id) {
    const agg = this._aggs.find(f => f.id === id);
    return agg === undefined ? null : agg;
  }
  removeCounterFields() {
    this._fields = this._fields.filter(f => f.counter === false);
  }
}
exports.NewJobCapabilitiesServiceBase = NewJobCapabilitiesServiceBase;