"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerControl = LayerControl;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _layer_toc = require("./layer_toc");
var _kibana_services = require("../../../kibana_services");
var _expand_button = require("./expand_button");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LayerControl({
  isReadOnly,
  isLayerTOCOpen,
  showAddLayerWizard,
  closeLayerTOC,
  openLayerTOC,
  layerList,
  isFlyoutOpen,
  hideAllLayers,
  showAllLayers,
  zoom
}) {
  if (!isLayerTOCOpen) {
    if ((0, _kibana_services.isScreenshotMode)()) {
      return null;
    }
    const hasErrorsOrWarnings = layerList.some(layer => {
      return layer.hasErrors() || layer.hasWarnings();
    });
    const isLoading = layerList.some(layer => {
      return layer.isLayerLoading(zoom);
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      delay: "long",
      content: _i18n.i18n.translate('xpack.maps.layerControl.openLayerTOCButtonAriaLabel', {
        defaultMessage: 'Expand layers panel'
      }),
      position: "left"
    }, /*#__PURE__*/_react.default.createElement(_expand_button.ExpandButton, {
      hasErrorsOrWarnings: hasErrorsOrWarnings,
      isLoading: isLoading,
      onClick: openLayerTOC
    }));
  }
  let addLayer;
  if (!isReadOnly) {
    addLayer = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isDisabled: isFlyoutOpen,
      className: "mapLayerControl__addLayerButton",
      fill: true,
      fullWidth: true,
      onClick: showAddLayerWizard,
      "data-test-subj": "addLayerButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.layerControl.addLayerButtonLabel",
      defaultMessage: "Add layer"
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    className: "mapWidgetControl mapWidgetControl-hasShadow",
    paddingSize: "none",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "mapWidgetControl__headerFlexItem",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    responsive: false,
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    className: "mapWidgetControl__header"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.layerControl.layersTitle",
    defaultMessage: "Layers"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "long",
    content: _i18n.i18n.translate('xpack.maps.layerControl.hideAllLayersButton', {
      defaultMessage: 'Hide all layers'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: hideAllLayers,
    iconType: "eyeClosed",
    color: "text",
    "aria-label": _i18n.i18n.translate('xpack.maps.layerControl.hideAllLayersButton', {
      defaultMessage: 'Hide all layers'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "long",
    content: _i18n.i18n.translate('xpack.maps.layerControl.showAllLayersButton', {
      defaultMessage: 'Show all layers'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: showAllLayers,
    iconType: "eye",
    color: "text",
    "aria-label": _i18n.i18n.translate('xpack.maps.layerControl.showAllLayersButton', {
      defaultMessage: 'Show all layers'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "long",
    content: _i18n.i18n.translate('xpack.maps.layerControl.closeLayerTOCButtonAriaLabel', {
      defaultMessage: 'Collapse layers panel'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    className: "mapLayerControl__closeLayerTOCButton",
    onClick: closeLayerTOC,
    iconType: "menuRight",
    color: "text",
    "aria-label": _i18n.i18n.translate('xpack.maps.layerControl.closeLayerTOCButtonAriaLabel', {
      defaultMessage: 'Collapse layers panel'
    }),
    "data-test-subj": "mapToggleLegendButton"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "mapLayerControl"
  }, /*#__PURE__*/_react.default.createElement(_layer_toc.LayerTOC, null))), addLayer);
}