"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTreeView = void 0;
var _react = require("react");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _constants = require("../../../common/constants");
var _add_timerange_and_default_filter_to_query = require("../../utils/add_timerange_and_default_filter_to_query");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTreeView = ({
  globalFilter,
  indexPattern
}) => {
  const [noResults, setNoResults] = (0, _react.useState)(false);
  const [treeNavSelection = {}, setTreeNavSelection] = (0, _useLocalStorage.default)(_constants.LOCAL_STORAGE_TREE_NAV_KEY, {});
  const filterQueryWithTimeRange = (0, _react.useMemo)(() => {
    return JSON.parse((0, _add_timerange_and_default_filter_to_query.addTimerangeAndDefaultFilterToQuery)(globalFilter.filterQuery, globalFilter.startDate, globalFilter.endDate));
  }, [globalFilter.filterQuery, globalFilter.startDate, globalFilter.endDate]);
  const onTreeNavSelect = (0, _react.useCallback)(selection => {
    setTreeNavSelection(selection);
  }, [setTreeNavSelection]);
  const sessionViewFilter = (0, _react.useMemo)(() => (0, _helpers.addTreeNavSelectionToFilterQuery)(globalFilter.filterQuery, treeNavSelection), [globalFilter.filterQuery, treeNavSelection]);
  return {
    noResults,
    setNoResults,
    filterQueryWithTimeRange,
    indexPattern: (indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.title) || '',
    onTreeNavSelect,
    treeNavSelection,
    setTreeNavSelection,
    sessionViewFilter
  };
};
exports.useTreeView = useTreeView;