"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
var _hooks = require("../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = () => {
  const {
    euiTheme
  } = (0, _hooks.useEuiTheme)();
  const cached = (0, _react.useMemo)(() => {
    const {
      size,
      colors
    } = euiTheme;
    const container = {
      paddingTop: size.s,
      paddingBottom: size.s,
      paddingRight: size.base,
      paddingLeft: size.base,
      border: euiTheme.border.thin,
      borderRadius: euiTheme.border.radius.medium,
      overflow: 'auto',
      height: '228px',
      position: 'relative',
      marginBottom: size.l
    };
    const dataInfo = {
      display: 'flex',
      alignItems: 'center',
      height: size.base,
      position: 'relative'
    };
    const filters = {
      marginLeft: size.s,
      position: 'absolute',
      left: '50%',
      backgroundColor: colors.emptyShade,
      borderRadius: euiTheme.border.radius.small,
      border: euiTheme.border.thin,
      bottom: '-25px',
      boxShadow: `0 ${size.xs} ${size.xs} ${(0, _eui.transparentize)(euiTheme.colors.shadow, 0.04)}`,
      display: 'flex',
      zIndex: 1
    };
    const countValue = {
      fontSize: size.m
    };
    const truncate = {
      width: '100%',
      overflow: 'hidden',
      whiteSpace: 'nowrap',
      textOverflow: 'ellipsis'
    };
    const flexWidth = {
      width: '100%'
    };
    const cellPad = {
      paddingBottom: '5px',
      paddingTop: '5px'
    };
    return {
      container,
      dataInfo,
      filters,
      countValue,
      truncate,
      flexWidth,
      cellPad
    };
  }, [euiTheme]);
  return cached;
};
exports.useStyles = useStyles;