"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateIntegrationAssistant = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _header = require("./header");
var _footer = require("./footer");
var _use_navigate = require("../../../common/hooks/use_navigate");
var _connector_step = require("./steps/connector_step");
var _integration_step = require("./steps/integration_step");
var _data_stream_step = require("./steps/data_stream_step");
var _review_step = require("./steps/review_step");
var _cel_input_step = require("./steps/cel_input_step");
var _review_cel_step = require("./steps/review_cel_step");
var _deploy_step = require("./steps/deploy_step");
var _state = require("./state");
var _telemetry = require("../telemetry");
var _services = require("../../../services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const stepNames = {
  1: 'Connector Step',
  2: 'Integration Step',
  3: 'DataStream Step',
  4: 'Review Step',
  cel_input: 'CEL Input Step',
  cel_review: 'CEL Review Step',
  deploy: 'Deploy Step'
};
const CreateIntegrationAssistant = exports.CreateIntegrationAssistant = /*#__PURE__*/_react.default.memo(() => {
  const [state, dispatch] = (0, _react.useReducer)(_state.reducer, _state.initialState);
  const navigate = (0, _use_navigate.useNavigate)();
  const {
    generateCel: isGenerateCelEnabled
  } = _services.ExperimentalFeaturesService.get();
  const celInputStepIndex = isGenerateCelEnabled && state.hasCelInput ? 5 : null;
  const celReviewStepIndex = isGenerateCelEnabled && state.celInputResult ? 6 : null;
  const deployStepIndex = celInputStepIndex !== null || celReviewStepIndex !== null || state.step === 7 ? 7 : 5;
  const stepName = state.step === deployStepIndex ? stepNames.deploy : state.step === celReviewStepIndex ? stepNames.cel_review : state.step === celInputStepIndex ? stepNames.cel_input : state.step in stepNames ? stepNames[state.step] : 'Unknown Step';
  const telemetry = (0, _telemetry.useTelemetry)();
  (0, _react.useEffect)(() => {
    telemetry.reportAssistantOpen();
  }, [telemetry]);
  const isThisStepReadyToComplete = (0, _react.useMemo)(() => {
    if (state.step === 1) {
      return (0, _connector_step.isConnectorStepReadyToComplete)(state);
    } else if (state.step === 2) {
      return (0, _integration_step.isIntegrationStepReadyToComplete)(state);
    } else if (state.step === 3) {
      return (0, _data_stream_step.isDataStreamStepReadyToComplete)(state);
    } else if (state.step === 4) {
      return (0, _review_step.isReviewStepReadyToComplete)(state);
    } else if (isGenerateCelEnabled && state.step === 5) {
      return (0, _cel_input_step.isCelInputStepReadyToComplete)(state);
    } else if (isGenerateCelEnabled && state.step === 6) {
      return (0, _review_cel_step.isCelReviewStepReadyToComplete)(state);
    }
    return false;
  }, [state, isGenerateCelEnabled]);
  const goBackStep = (0, _react.useCallback)(() => {
    if (state.step === 1) {
      navigate(_use_navigate.Page.landing);
    } else {
      dispatch({
        type: 'SET_STEP',
        payload: state.step - 1
      });
    }
  }, [navigate, dispatch, state.step]);
  const completeStep = (0, _react.useCallback)(() => {
    if (!isThisStepReadyToComplete) {
      // If the user tries to navigate to the next step without completing the current step.
      return;
    }
    telemetry.reportAssistantStepComplete({
      step: state.step,
      stepName
    });
    if (state.step === 3 || state.step === celInputStepIndex) {
      dispatch({
        type: 'SET_IS_GENERATING',
        payload: true
      });
    } else {
      dispatch({
        type: 'SET_STEP',
        payload: state.step + 1
      });
    }
  }, [telemetry, state.step, stepName, celInputStepIndex, isThisStepReadyToComplete]);
  const actions = (0, _react.useMemo)(() => ({
    setStep: payload => {
      dispatch({
        type: 'SET_STEP',
        payload
      });
    },
    setConnector: payload => {
      dispatch({
        type: 'SET_CONNECTOR',
        payload
      });
    },
    setIntegrationSettings: payload => {
      dispatch({
        type: 'SET_INTEGRATION_SETTINGS',
        payload
      });
    },
    setIsGenerating: payload => {
      dispatch({
        type: 'SET_IS_GENERATING',
        payload
      });
    },
    setHasCelInput: payload => {
      dispatch({
        type: 'SET_HAS_CEL_INPUT',
        payload
      });
    },
    setResult: payload => {
      dispatch({
        type: 'SET_GENERATED_RESULT',
        payload
      });
    },
    setCelInputResult: payload => {
      dispatch({
        type: 'SET_CEL_INPUT_RESULT',
        payload
      });
    },
    completeStep
  }), [completeStep]);
  return /*#__PURE__*/_react.default.createElement(_state.ActionsProvider, {
    value: actions
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, null, /*#__PURE__*/_react.default.createElement(_header.Header, {
    currentStep: state.step,
    isGenerating: state.isGenerating
  }), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    grow: true,
    paddingSize: "l"
  }, state.step === 1 && /*#__PURE__*/_react.default.createElement(_connector_step.ConnectorStep, {
    connector: state.connector
  }), state.step === 2 && /*#__PURE__*/_react.default.createElement(_integration_step.IntegrationStep, {
    integrationSettings: state.integrationSettings
  }), state.step === 3 && /*#__PURE__*/_react.default.createElement(_data_stream_step.DataStreamStep, {
    integrationSettings: state.integrationSettings,
    connector: state.connector,
    isGenerating: state.isGenerating
  }), state.step === 4 && /*#__PURE__*/_react.default.createElement(_review_step.ReviewStep, {
    integrationSettings: state.integrationSettings,
    isGenerating: state.isGenerating,
    result: state.result
  }), state.step === celInputStepIndex && /*#__PURE__*/_react.default.createElement(_cel_input_step.CelInputStep, {
    integrationSettings: state.integrationSettings,
    connector: state.connector,
    isGenerating: state.isGenerating
  }), state.step === celReviewStepIndex && /*#__PURE__*/_react.default.createElement(_review_cel_step.ReviewCelStep, {
    isGenerating: state.isGenerating,
    celInputResult: state.celInputResult
  }), state.step === deployStepIndex && /*#__PURE__*/_react.default.createElement(_deploy_step.DeployStep, {
    integrationSettings: state.integrationSettings,
    result: state.result,
    celInputResult: state.celInputResult,
    connector: state.connector
  })), /*#__PURE__*/_react.default.createElement(_footer.Footer, {
    isGenerating: state.isGenerating,
    isAnalyzeStep: state.step === 3,
    isAnalyzeCelStep: state.step === celInputStepIndex,
    isLastStep: state.step === deployStepIndex,
    isNextStepEnabled: isThisStepReadyToComplete && !state.isGenerating,
    isNextAddingToElastic: state.step === deployStepIndex - 1,
    onBack: goBackStep,
    onNext: completeStep
  })));
});
CreateIntegrationAssistant.displayName = 'CreateIntegrationAssistant';