"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTypeLabel = exports.getDeleteDatabaseSuccessMessage = exports.getAddDatabaseSuccessMessage = exports.deleteDatabaseErrorTitle = exports.addDatabaseErrorTitle = exports.IPINFO_NAME_OPTIONS = exports.GEOIP_NAME_OPTIONS = exports.DELETE_DATABASE_MODAL_TITLE_ID = exports.DELETE_DATABASE_MODAL_FORM_ID = exports.DATABASE_TYPE_OPTIONS = exports.ADD_DATABASE_MODAL_TITLE_ID = exports.ADD_DATABASE_MODAL_FORM_ID = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_DATABASE_MODAL_TITLE_ID = exports.ADD_DATABASE_MODAL_TITLE_ID = 'manageProcessorsAddGeoipDatabase';
const ADD_DATABASE_MODAL_FORM_ID = exports.ADD_DATABASE_MODAL_FORM_ID = 'manageProcessorsAddGeoipDatabaseForm';
const DATABASE_TYPE_OPTIONS = exports.DATABASE_TYPE_OPTIONS = [{
  value: 'maxmind',
  text: _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.geoip.maxmindDatabaseType', {
    defaultMessage: 'MaxMind'
  })
}, {
  value: 'ipinfo',
  text: _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.geoip.ipinfoDatabaseType', {
    defaultMessage: 'IPinfo'
  })
}];
const GEOIP_NAME_OPTIONS = exports.GEOIP_NAME_OPTIONS = [{
  value: 'GeoIP2-Anonymous-IP',
  text: _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.geoip.anonymousIPDatabaseName', {
    defaultMessage: 'GeoIP2 Anonymous IP'
  })
}, {
  value: 'GeoIP2-City',
  text: _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.geoip.cityDatabaseName', {
    defaultMessage: 'GeoIP2 City'
  })
}, {
  value: 'GeoIP2-Connection-Type',
  text: _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.geoip.connectionTypeDatabaseName', {
    defaultMessage: 'GeoIP2 Connection Type'
  })
}, {
  value: 'GeoIP2-Country',
  text: _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.geoip.countryDatabaseName', {
    defaultMessage: 'GeoIP2 Country'
  })
}, {
  value: 'GeoIP2-Domain',
  text: _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.geoip.domainDatabaseName', {
    defaultMessage: 'GeoIP2 Domain'
  })
}, {
  value: 'GeoIP2-Enterprise',
  text: _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.geoip.enterpriseDatabaseName', {
    defaultMessage: 'GeoIP2 Enterprise'
  })
}, {
  value: 'GeoIP2-ISP',
  text: _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.geoip.ispDatabaseName', {
    defaultMessage: 'GeoIP2 ISP'
  })
}];
const IPINFO_NAME_OPTIONS = exports.IPINFO_NAME_OPTIONS = [{
  value: 'asn',
  text: _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.ipinfo.freeAsnDatabaseName', {
    defaultMessage: 'Free IP to ASN'
  })
}, {
  value: 'country',
  text: _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.ipinfo.freeCountryDatabaseName', {
    defaultMessage: 'Free IP to Country'
  })
}, {
  value: 'standard_asn',
  text: _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.ipinfo.asnDatabaseName', {
    defaultMessage: 'ASN'
  })
}, {
  value: 'standard_location',
  text: _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.ipinfo.ipGeolocationDatabaseName', {
    defaultMessage: 'IP Geolocation'
  })
}, {
  value: 'standard_privacy',
  text: _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.ipinfo.privacyDetectionDatabaseName', {
    defaultMessage: 'Privacy Detection'
  })
}];
const getAddDatabaseSuccessMessage = databaseName => {
  return _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.geoip.addDatabaseSuccessMessage', {
    defaultMessage: 'Added database {databaseName}',
    values: {
      databaseName
    }
  });
};
exports.getAddDatabaseSuccessMessage = getAddDatabaseSuccessMessage;
const addDatabaseErrorTitle = exports.addDatabaseErrorTitle = _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.geoip.addDatabaseErrorTitle', {
  defaultMessage: 'Error adding database'
});
const DELETE_DATABASE_MODAL_TITLE_ID = exports.DELETE_DATABASE_MODAL_TITLE_ID = 'manageProcessorsDeleteGeoipDatabase';
const DELETE_DATABASE_MODAL_FORM_ID = exports.DELETE_DATABASE_MODAL_FORM_ID = 'manageProcessorsDeleteGeoipDatabaseForm';
const getDeleteDatabaseSuccessMessage = databaseName => {
  return _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.geoip.deleteDatabaseSuccessMessage', {
    defaultMessage: 'Deleted database {databaseName}',
    values: {
      databaseName
    }
  });
};
exports.getDeleteDatabaseSuccessMessage = getDeleteDatabaseSuccessMessage;
const deleteDatabaseErrorTitle = exports.deleteDatabaseErrorTitle = _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.geoip.deleteDatabaseErrorTitle', {
  defaultMessage: 'Error deleting database'
});
const getTypeLabel = type => {
  switch (type) {
    case 'maxmind':
      {
        return _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.geoip.list.typeMaxmindLabel', {
          defaultMessage: 'MaxMind'
        });
      }
    case 'ipinfo':
      {
        return _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.geoip.list.typeIpinfoLabel', {
          defaultMessage: 'IPinfo'
        });
      }
    case 'web':
      {
        return _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.geoip.list.webLabel', {
          defaultMessage: 'Web'
        });
      }
    case 'local':
      {
        return _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.geoip.list.localLabel', {
          defaultMessage: 'Local'
        });
      }
    case 'unknown':
    default:
      {
        return _i18n.i18n.translate('xpack.ingestPipelines.manageProcessors.geoip.list.typeUnknownLabel', {
          defaultMessage: 'Unknown'
        });
      }
  }
};
exports.getTypeLabel = getTypeLabel;