"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InlineLogViewCallout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InlineLogViewCallout = ({
  revertToDefaultLogView
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logs.settings.inlineLogViewCalloutWidgetTitle",
      defaultMessage: "You are configuring an embedded widget"
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logs.settings.inlineLogViewCalloutWidgetDescription",
    defaultMessage: "Changes will be synchronized to the URL, but they will not be persisted to the default Logs Stream view."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraInlineLogViewCalloutRevertToDefaultPersistedLogViewButton",
    fullWidth: false,
    color: "warning",
    onClick: revertToDefaultLogView
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logs.settings.inlineLogViewCalloutButtonText",
    defaultMessage: "Revert to default Logs Stream view"
  }))));
};
exports.InlineLogViewCallout = InlineLogViewCallout;