"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateUniqueName = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateUniqueName = ({
  rootLevelFields,
  byId
}, initialName = '', parentId) => {
  const validator = ({
    value
  }) => {
    const existingNames = parentId ? Object.values(byId).filter(field => field.parentId === parentId).map(field => field.source.name) : rootLevelFields.map(fieldId => byId[fieldId].source.name);
    if (existingNames.filter(name => name !== initialName).includes(value)) {
      return {
        message: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.existNamesValidationErrorMessage', {
          defaultMessage: 'There is already a field with this name.'
        })
      };
    }
  };
  return validator;
};
exports.validateUniqueName = validateUniqueName;