"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UpdateIcon = ({
  size = 'm'
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  "aria-label": _i18n.i18n.translate('xpack.fleet.epm.updateAvailableTooltip', {
    defaultMessage: 'Update available'
  }),
  size: size,
  type: "warning",
  color: "warning",
  content: _i18n.i18n.translate('xpack.fleet.epm.updateAvailableTooltip', {
    defaultMessage: 'Update available'
  })
});
exports.UpdateIcon = UpdateIcon;