"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EcsFieldsRepository = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _mapValues = _interopRequireDefault(require("lodash/mapValues"));
var _fields_metadata_dictionary = require("../../../../common/fields_metadata/models/fields_metadata_dictionary");
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EcsFieldsRepository {
  constructor(ecsFields) {
    (0, _defineProperty2.default)(this, "ecsFields", void 0);
    this.ecsFields = (0, _mapValues.default)(ecsFields, field => _common.FieldMetadata.create({
      ...field,
      source: 'ecs'
    }));
  }
  getByName(fieldName) {
    return this.ecsFields[fieldName];
  }
  find({
    fieldNames
  } = {}) {
    if (!fieldNames) {
      return _fields_metadata_dictionary.FieldsMetadataDictionary.create(this.ecsFields);
    }
    const fields = fieldNames.reduce((fieldsMetadata, fieldName) => {
      const field = this.getByName(fieldName);
      if (field) {
        fieldsMetadata[fieldName] = field;
      }
      return fieldsMetadata;
    }, {});
    return _fields_metadata_dictionary.FieldsMetadataDictionary.create(fields);
  }
  static create({
    ecsFields
  }) {
    return new EcsFieldsRepository(ecsFields);
  }
}
exports.EcsFieldsRepository = EcsFieldsRepository;