"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSortCommand = void 0;
exports.visitOrderExpressions = visitOrderExpressions;
var _builder = require("../../builder");
var _factories = require("../factories");
var _walkers = require("../walkers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createSortCommand = ctx => {
  const command = (0, _factories.createCommand)('sort', ctx);
  command.args.push(...visitOrderExpressions(ctx.orderExpression_list()));
  return command;
};
exports.createSortCommand = createSortCommand;
function visitOrderExpressions(ctx) {
  const ast = [];
  for (const orderCtx of ctx) {
    ast.push(visitOrderExpression(orderCtx));
  }
  return ast;
}
const visitOrderExpression = ctx => {
  var _ctx$_ordering, _ctx$_ordering$text, _ctx$_nullOrdering, _ctx$_nullOrdering$te;
  const arg = (0, _walkers.collectBooleanExpression)(ctx.booleanExpression())[0];
  let order = '';
  let nulls = '';
  const ordering = (_ctx$_ordering = ctx._ordering) === null || _ctx$_ordering === void 0 ? void 0 : (_ctx$_ordering$text = _ctx$_ordering.text) === null || _ctx$_ordering$text === void 0 ? void 0 : _ctx$_ordering$text.toUpperCase();
  if (ordering) order = ordering;
  const nullOrdering = (_ctx$_nullOrdering = ctx._nullOrdering) === null || _ctx$_nullOrdering === void 0 ? void 0 : (_ctx$_nullOrdering$te = _ctx$_nullOrdering.text) === null || _ctx$_nullOrdering$te === void 0 ? void 0 : _ctx$_nullOrdering$te.toUpperCase();
  switch (nullOrdering) {
    case 'LAST':
      nulls = 'NULLS LAST';
      break;
    case 'FIRST':
      nulls = 'NULLS FIRST';
      break;
  }
  if (!order && !nulls) {
    return arg;
  }
  return createOrderExpression(ctx, arg, order, nulls);
};
const createOrderExpression = (ctx, arg, order, nulls) => {
  const node = _builder.Builder.expression.order(arg, {
    order,
    nulls
  }, (0, _factories.createParserFields)(ctx));
  return node;
};