"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddSourceBYOIntro = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../../../shared/doc_links");
var _react_router_helpers = require("../../../../../shared/react_router_helpers");
var _app_logic = require("../../../../app_logic");
var _connection_illustration = _interopRequireDefault(require("../../../../assets/connection_illustration.svg"));
var _layout = require("../../../../components/layout");
var _constants = require("../../../../constants");
var _routes = require("../../../../routes");
var _source_data = require("../../source_data");
var _add_source_header = require("./add_source_header");
require("./add_source.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddSourceBYOIntro = () => {
  const {
    name,
    categories = [],
    serviceType
  } = _source_data.staticGenericExternalSourceData;
  const {
    isOrganization
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const Layout = isOrganization ? _layout.WorkplaceSearchPageTemplate : _layout.PersonalDashboardLayout;
  const to = `${(0, _routes.getSourcesPath)((0, _routes.getAddPath)(serviceType), isOrganization)}/connector_registration`;
  return /*#__PURE__*/_react.default.createElement(Layout, {
    pageChrome: [_constants.NAV.SOURCES, _constants.NAV.ADD_SOURCE, name]
  }, /*#__PURE__*/_react.default.createElement(_add_source_header.AddSourceHeader, {
    name: name,
    serviceType: serviceType,
    categories: categories
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "flexStart",
    direction: "row",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "stretch",
    direction: "row",
    gutterSize: "xl",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "adding-a-source__intro-image"
  }, /*#__PURE__*/_react.default.createElement("img", {
    src: _connection_illustration.default,
    alt: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.byoConfigIntro.alt.text', {
      defaultMessage: 'Connection illustration'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    className: "adding-a-source__intro-steps"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.byoConfigIntro.steps.title', {
    defaultMessage: 'Build and deploy a custom connector package to add data from custom content sources, or modify the behavior of first party content sources'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    justifyContent: "flexStart",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "adding-a-source__intro-step"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.byoConfigIntro.step1.heading', {
    defaultMessage: 'Step 1'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    grow: false
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.contentSource.byoConfigIntro.step1.title",
    defaultMessage: "Build or modify the code"
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.contentSource.byoConfigIntro.step1.text",
    defaultMessage: "In the Connector Package {repositoryLink}, there\u2019s everything you need to understand the connector framework and get set up with your coding environment.",
    values: {
      repositoryLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        target: "_blank",
        href: "https://github.com/elastic/connectors"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.byoConfigIntro.step1.repositoryLinkLabel', {
        defaultMessage: 'repository'
      }))
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    justifyContent: "flexStart",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "adding-a-source__intro-step"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.byoConfigIntro.step2.heading', {
    defaultMessage: 'Step 2'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    grow: false
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.contentSource.byoConfigIntro.step2.title",
    defaultMessage: "Deploy your custom connector package"
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.contentSource.byoConfigIntro.step2.text",
    defaultMessage: "Connector packages are self managed on the infrastructure you deploy. Review the {documentationLink} for prerequisites to get started with your deployment.",
    values: {
      documentationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        target: "_blank",
        href: _doc_links.docLinks.workplaceSearchCustomConnectorPackage
      }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.byoConfigIntro.step2.documentationLinkLabel', {
        defaultMessage: 'documentation'
      }))
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    grow: false
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.contentSource.byoConfigIntro.step3.text",
    defaultMessage: "Once you\u2019ve built and deployed your connector package, come back here to register your connector package deployment, finalize configuration and connect to your content sources."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
    color: "primary",
    "data-test-subj": "ConfigureStepButton",
    fill: true,
    to: to
  }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.contentSource.byoConfigIntro.configure.button', {
    defaultMessage: 'Register your deployment'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  })))))))));
};
exports.AddSourceBYOIntro = AddSourceBYOIntro;