"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VersionMismatchError = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VersionMismatchError = ({
  enterpriseSearchVersion,
  kibanaVersion
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    iconColor: "danger",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.versionMismatch.title', {
      defaultMessage: 'Incompatible version error'
    })),
    titleSize: "l",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.enterpriseSearch.versionMismatch.body', {
      defaultMessage: 'Your Kibana and Enterprise Search versions do not match. To access Enterprise Search, use the same major and minor version for each service.'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("div", null, _i18n.i18n.translate('xpack.enterpriseSearch.versionMismatch.enterpriseSearchVersionText', {
      defaultMessage: 'Enterprise Search version: {enterpriseSearchVersion}',
      values: {
        enterpriseSearchVersion
      }
    })), /*#__PURE__*/_react.default.createElement("div", null, _i18n.i18n.translate('xpack.enterpriseSearch.versionMismatch.kibanaVersionText', {
      defaultMessage: 'Kibana version: {kibanaVersion}',
      values: {
        kibanaVersion
      }
    })))
  });
};
exports.VersionMismatchError = VersionMismatchError;