"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlCustomSettingsFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../shared/constants");
var _loading = require("../../../../../shared/loading");
var _crawl_custom_settings_flyout_crawl_depth_panel = require("./crawl_custom_settings_flyout_crawl_depth_panel");
var _crawl_custom_settings_flyout_crawl_type_select = require("./crawl_custom_settings_flyout_crawl_type_select");
var _crawl_custom_settings_flyout_domains_panel = require("./crawl_custom_settings_flyout_domains_panel");
var _crawl_custom_settings_flyout_logic = require("./crawl_custom_settings_flyout_logic");
var _crawl_custom_settings_flyout_multi_crawl_delete = require("./crawl_custom_settings_flyout_multi_crawl_delete");
var _crawl_custom_settings_flyout_multi_crawl_logic = require("./crawl_custom_settings_flyout_multi_crawl_logic");
var _crawl_custom_settings_flyout_multi_crawl_tabs = require("./crawl_custom_settings_flyout_multi_crawl_tabs");
var _crawl_custom_settings_flyout_mutli_crawl = require("./crawl_custom_settings_flyout_mutli_crawl");
var _crawl_custom_settings_flyout_seed_urls_panel = require("./crawl_custom_settings_flyout_seed_urls_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlCustomSettingsFlyout = () => {
  const {
    isDataLoading,
    isFormSubmitting,
    isFlyoutVisible,
    isSingleCrawlType,
    selectedDomainUrls
  } = (0, _kea.useValues)(_crawl_custom_settings_flyout_logic.CrawlCustomSettingsFlyoutLogic);
  const {
    crawlerCustomSchedulingIsValid
  } = (0, _kea.useValues)(_crawl_custom_settings_flyout_multi_crawl_logic.CrawlCustomSettingsFlyoutMultiCrawlLogic);
  const {
    hideFlyout,
    startCustomCrawl,
    saveCustomSchedulingConfiguration
  } = (0, _kea.useActions)(_crawl_custom_settings_flyout_logic.CrawlCustomSettingsFlyoutLogic);
  if (!isFlyoutVisible) {
    return null;
  }
  const submitFunctionLogic = isSingleCrawlType ? startCustomCrawl : saveCustomSchedulingConfiguration;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: hideFlyout,
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlCustomSettingsFlyout.flyoutHeadTitle', {
    defaultMessage: 'Custom crawl configuration'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlCustomSettingsFlyout.flyoutHeaderDescription', {
    defaultMessage: 'Set up a one-time crawl or multiple crawling custom settings.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, isDataLoading ? /*#__PURE__*/_react.default.createElement(_loading.Loading, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_crawl_custom_settings_flyout_crawl_type_select.CrawlCustomSettingsFlyoutCrawlTypeSelection, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), isSingleCrawlType ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_crawl_custom_settings_flyout_crawl_depth_panel.CrawlCustomSettingsFlyoutCrawlDepthPanelWithLogicProps, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_crawl_custom_settings_flyout_domains_panel.CrawlCustomSettingsFlyoutDomainsPanelWithLogicProps, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_crawl_custom_settings_flyout_seed_urls_panel.CrawlCustomSettingsFlyoutSeedUrlsPanelWithLogicProps, null)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_crawl_custom_settings_flyout_multi_crawl_tabs.CrawlCustomSettingsFlyoutMultipleCrawlTabs, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_crawl_custom_settings_flyout_mutli_crawl.CrawlCustomSettingsFlyoutMultiCrawlScheduling, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_crawl_custom_settings_flyout_multi_crawl_delete.CrawlCustomSettingsFlyoutMultipleCrawlDelete, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": "entSearchContent-crawler-customCrawlSettings-cancelStartCrawl",
    onClick: hideFlyout
  }, _constants.CANCEL_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchContent-crawler-customCrawlSettings-startCrawl",
    fill: true,
    onClick: submitFunctionLogic,
    disabled: isSingleCrawlType ? isDataLoading || selectedDomainUrls.length === 0 : !crawlerCustomSchedulingIsValid,
    isLoading: isFormSubmitting
  }, isSingleCrawlType ? _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlCustomSettingsFlyout.startCrawlButtonLabel', {
    defaultMessage: 'Apply and crawl now'
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlCustomSettingsFlyout.saveMultipleCrawlersConfiguration', {
    defaultMessage: 'Save configuration'
  }))))));
};
exports.CrawlCustomSettingsFlyout = CrawlCustomSettingsFlyout;