"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getESQLSingleColumnValues = void 0;
var _esqlUtils = require("@kbn/esql-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getESQLSingleColumnValues = async ({
  query,
  search,
  timeRange
}) => {
  try {
    const results = await (0, _esqlUtils.getESQLResults)({
      esqlQuery: query,
      search,
      signal: undefined,
      filter: undefined,
      dropNullColumns: true,
      timeRange
    });
    const columns = results.response.columns.map(col => col.name);
    if (columns.length === 1) {
      const values = results.response.values.map(value => value[0]).filter(Boolean).map(option => String(option));
      return {
        values
      };
    }
    return {
      errors: [new Error('Query must return a single column')]
    };
  } catch (e) {
    return {
      errors: [e]
    };
  }
};
exports.getESQLSingleColumnValues = getESQLSingleColumnValues;
getESQLSingleColumnValues.isSuccess = result => 'values' in result;