"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldsSelectorModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _fields_selector_table = require("./fields_selector_table");
var _test_subjects = require("../../test_subjects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const title = _i18n.i18n.translate('xpack.csp.dataTable.fieldsModalTitle', {
  defaultMessage: 'Fields'
});
const FieldsSelectorModal = ({
  closeModal,
  dataView,
  columns,
  onAddColumn,
  onRemoveColumn,
  onResetColumns
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal,
    "data-test-subj": _test_subjects.CSP_FIELDS_SELECTOR_MODAL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_fields_selector_table.FieldsSelectorTable, {
    title: title,
    dataView: dataView,
    columns: columns,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onResetColumns,
    "data-test-subj": _test_subjects.CSP_FIELDS_SELECTOR_RESET_BUTTON
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.dataTable.fieldsModalReset",
    defaultMessage: "Reset Fields"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: closeModal,
    fill: true,
    "data-test-subj": _test_subjects.CSP_FIELDS_SELECTOR_CLOSE_BUTTON
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.dataTable.fieldsModalClose",
    defaultMessage: "Close"
  }))));
};
exports.FieldsSelectorModal = FieldsSelectorModal;