"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageControls = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getClonePageAriaLabel: () => _i18n.i18n.translate('xpack.canvas.pagePreviewPageControls.clonePageAriaLabel', {
    defaultMessage: 'Clone page'
  }),
  getClonePageTooltip: () => _i18n.i18n.translate('xpack.canvas.pagePreviewPageControls.clonePageTooltip', {
    defaultMessage: 'Clone'
  }),
  getDeletePageAriaLabel: () => _i18n.i18n.translate('xpack.canvas.pagePreviewPageControls.deletePageAriaLabel', {
    defaultMessage: 'Delete page'
  }),
  getDeletePageTooltip: () => _i18n.i18n.translate('xpack.canvas.pagePreviewPageControls.deletePageTooltip', {
    defaultMessage: 'Delete'
  })
};
const PageControls = ({
  pageId,
  onRemove,
  onDuplicate
}) => {
  const handleDuplicate = ev => {
    ev.preventDefault();
    onDuplicate(pageId);
  };
  const handleRemove = ev => {
    ev.preventDefault();
    onRemove(pageId);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "canvasPageManager__controls",
    gutterSize: "xs",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: strings.getClonePageTooltip()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "copy",
    "aria-label": strings.getClonePageAriaLabel(),
    onClick: handleDuplicate
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: strings.getDeletePageTooltip()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "danger",
    iconType: "trash",
    "aria-label": strings.getDeletePageAriaLabel(),
    onClick: handleRemove
  }))));
};
exports.PageControls = PageControls;
PageControls.propTypes = {
  pageId: _propTypes.default.string.isRequired,
  onRemove: _propTypes.default.func.isRequired,
  onDuplicate: _propTypes.default.func.isRequired
};