"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceCorrelationAnalysis = TraceCorrelationAnalysis;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TraceCorrelationAnalysis({
  traceCorrelation,
  traceId,
  sourceNode,
  destinationNode
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!traceId || !traceCorrelation) {
    return null;
  }
  const {
    found,
    foundInSourceNode,
    foundInDestinationNode,
    sourceNodeDocumentCount,
    destinationNodeDocumentCount
  } = traceCorrelation;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnostics.traceCorrelation.title', {
    defaultMessage: 'Trace Correlation Analysis'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), found ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "checkInCircleFilled",
    color: "success"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnostics.traceCorrelation.success', {
    defaultMessage: 'Trace found in both {sourceNode} and {destinationNode}',
    values: {
      sourceNode,
      destinationNode
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "success"
  }, sourceNodeDocumentCount + destinationNodeDocumentCount, ' ', _i18n.i18n.translate('xpack.apm.diagnosticResults.documentsBadgeLabel', {
    defaultMessage: 'documents'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnostics.traceCorrelation.successDetails', {
    defaultMessage: 'The trace was successfully found in both services: {sourceCount, plural, one {# document} other {# documents}} in {sourceNode} and {destinationCount, plural, one {# document} other {# documents}} in {destinationNode}. This indicates proper trace correlation between the services.',
    values: {
      sourceCount: sourceNodeDocumentCount,
      sourceNode,
      destinationCount: destinationNodeDocumentCount,
      destinationNode
    }
  })))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "alert",
    color: "warning"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnostics.traceCorrelation.notFound', {
    defaultMessage: 'Trace correlation issue detected'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning"
  }, _i18n.i18n.translate('xpack.apm.diagnosticResults.documentsBadgeLabel', {
    defaultMessage: '{count, plural, one {# document} other {# documents}}',
    values: {
      count: sourceNodeDocumentCount + destinationNodeDocumentCount
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnostics.traceCorrelation.notFoundDescription', {
    defaultMessage: 'Trace ID {traceId} was not found in both services during the selected time range. Found {sourceCount, plural, one {# document} other {# documents}} in {sourceNode} and {destinationCount, plural, one {# document} other {# documents}} in {destinationNode}. This could indicate:',
    values: {
      traceId,
      sourceCount: sourceNodeDocumentCount,
      sourceNode,
      destinationCount: destinationNodeDocumentCount,
      destinationNode
    }
  })), /*#__PURE__*/_react.default.createElement("ul", {
    style: {
      marginTop: euiTheme.size.s,
      paddingLeft: euiTheme.size.base
    }
  }, !foundInSourceNode && /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnostics.traceCorrelation.missingInSource', {
    defaultMessage: 'Trace not found in source service ({sourceNode})',
    values: {
      sourceNode
    }
  })), !foundInDestinationNode && /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnostics.traceCorrelation.missingInDestination', {
    defaultMessage: 'Trace not found in destination service ({destinationNode})',
    values: {
      destinationNode
    }
  })), /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnostics.traceCorrelation.timeRangeIssue', {
    defaultMessage: 'The trace may have occurred outside the selected time range'
  })), /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.apm.serviceMap.diagnostics.traceCorrelation.instrumentationIssue', {
    defaultMessage: 'Missing or incomplete distributed tracing instrumentation'
  }))))));
}