"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiQuickSelectPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../../../services");
var _title = require("../../../title");
var _quick_select_panel = require("./quick_select_panel.styles");
var _react2 = require("@emotion/react");
var _excluded = ["component", "title", "titleId", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiQuickSelectPanel = exports.EuiQuickSelectPanel = function EuiQuickSelectPanel(_ref) {
  var _ref$component = _ref.component,
    Component = _ref$component === void 0 ? 'div' : _ref$component,
    title = _ref.title,
    titleId = _ref.titleId,
    children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isFieldset = Component === 'fieldset';
  var TitleComponent = isFieldset ? 'legend' : 'span';
  var styles = (0, _services.useEuiMemoizedStyles)(_quick_select_panel.euiQuickSelectPanelStyles);
  return (0, _react2.jsx)(Component, _extends({
    css: styles.euiQuickSelectPanel
  }, rest), title ? (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_title.EuiTitle, {
    size: "xxxs"
  }, (0, _react2.jsx)(TitleComponent, {
    id: titleId,
    css: styles.euiQuickSelectPanel__title
  }, title)), (0, _react2.jsx)("div", {
    css: styles.euiQuickSelectPanel__section
  }, children)) : children);
};
EuiQuickSelectPanel.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  component: _propTypes.default.oneOf(["div", "fieldset"]),
  title: _propTypes.default.node,
  titleId: _propTypes.default.string,
  children: _propTypes.default.node
};