"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiAccordionChildrenStyles = exports.euiAccordionChildWrapperStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1xvjonu-isLoading",
  styles: "align-items:center;display:flex;label:isLoading;"
} : {
  name: "1xvjonu-isLoading",
  styles: "align-items:center;display:flex;label:isLoading;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiAccordionChildrenStyles = exports.euiAccordionChildrenStyles = function euiAccordionChildrenStyles(_ref2) {
  var euiTheme = _ref2.euiTheme;
  return {
    euiAccordion__children: /*#__PURE__*/(0, _react.css)(";label:euiAccordion__children;"),
    isLoading: _ref,
    xs: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.xs, ";;label:xs;"),
    s: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.s, ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.base, ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.l, ";;label:l;"),
    xl: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.xl, ";;label:xl;")
  };
};
var euiAccordionChildWrapperStyles = exports.euiAccordionChildWrapperStyles = function euiAccordionChildWrapperStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiAccordion__childWrapper: /*#__PURE__*/(0, _react.css)("overflow:hidden;", _global_styling.euiCanAnimate, "{transition:", _global_styling.logicals.height, " ", euiTheme.animation.normal, " ", euiTheme.animation.resistance, ",opacity ", euiTheme.animation.normal, " ", euiTheme.animation.resistance, ";}", (0, _global_styling.euiFocusRing)(euiThemeContext), ";;label:euiAccordion__childWrapper;"),
    // choosing to override transition instead of applying it conditionally
    // to keep a more logical style appliance:
    // default case = has transition as part of default styles (all cases expect initial isOpen=true when initialIsOpen=true)
    // special case: no transition for initial isOpen=true when initialIsOpen=true
    noTransition: /*#__PURE__*/(0, _react.css)(_global_styling.euiCanAnimate, "{transition:none;};label:noTransition;"),
    isClosed: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', 0), " opacity:0;;label:isClosed;"),
    isOpen: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', 'auto'), " opacity:1;;label:isOpen;")
  };
};