"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const stream_1 = require("stream");
const INDEX_NOT_FOUND = -1;
class DelimitedStream extends stream_1.Transform {
    constructor(delimiter, incl_delim = false) {
        super();
        this.buffer = Buffer.alloc(0);
        this.queue = [];
        this.delimiter = Buffer.from(delimiter.toString('utf8'));
        this.incl_delim = incl_delim;
    }
    _transform(chunk, _encoding_, callback) {
        this.updateQueue(chunk);
        this.pushQueue();
        callback();
    }
    _final(callback) {
        if (this.buffer.length !== 0) {
            this.updateQueue(this.delimiter);
            this.pushQueue();
        }
        callback();
    }
    updateQueue(chunk) {
        let temp_buffer = Buffer.concat([this.buffer, chunk]);
        let delimiter_index;
        let next_temp_buffer_index;
        do {
            delimiter_index = temp_buffer.indexOf(this.delimiter);
            if (delimiter_index === INDEX_NOT_FOUND)
                break;
            next_temp_buffer_index = delimiter_index + this.delimiter.length;
            this.queue.push(temp_buffer.slice(0, (this.incl_delim ? next_temp_buffer_index : delimiter_index)));
            temp_buffer = temp_buffer.slice(next_temp_buffer_index);
        } while (delimiter_index !== INDEX_NOT_FOUND);
        this.buffer = temp_buffer;
    }
    pushQueue() {
        while (true) {
            if (this.queue.length === 0 ||
                this.push(this.queue.shift()) === false)
                break;
        }
    }
}
exports.DelimitedStream = DelimitedStream;
