"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable class-methods-use-this */
const fs = require("fs");
const fsPromises = fs.promises;
class NodeFilesystem {
    async getFileTimestamp(path) {
        const stat = await fsPromises.stat(path);
        return stat.mtimeMs;
    }
    async readFile(path) {
        return fsPromises.readFile(path, 'utf8');
    }
    watch(path, callback) {
        return fs.watch(path, { persistent: false }, (eventType) => {
            callback(eventType, path);
        });
    }
}
exports.default = NodeFilesystem;
//# sourceMappingURL=NodeFilesystem.js.map